/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JSlider;
import uk.org.toot.control.FloatControl;

public class ControlSlider
extends JSlider
implements Observer {
    private final FloatControl control;

    public ControlSlider(FloatControl control) {
        super(1, 0, control.getLaw().getResolution() - 1, 0);
        this.control = control;
        super.setValue(this.sliderValue(control.getValue()));
        this.setPaintTrack(false);
    }

    public void addNotify() {
        super.addNotify();
        this.control.addObserver(this);
    }

    public void removeNotify() {
        this.control.deleteObserver(this);
        super.removeNotify();
    }

    public void update(Observable obs, Object obj) {
        super.setValue(this.sliderValue(this.control.getValue()));
    }

    protected float userValue(int sliderVal) {
        return this.control.getLaw().userValue(sliderVal);
    }

    protected int sliderValue(float userVal) {
        return this.control.getLaw().intValue(userVal);
    }

    public void setValue(int sliderVal) {
        super.setValue(sliderVal);
        this.control.setValue(this.userValue(sliderVal));
    }

    public Color getInsertColor() {
        return this.control.getInsertColor();
    }
}

