/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Dimension;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.swingui.controlui.ControlPanel;

public class BooleanIndicatorPanel
extends ControlPanel {
    private final BooleanControl control;
    private JLabel label;

    public BooleanIndicatorPanel(final BooleanControl control) {
        super(control);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.control = control;
        String name = this.abbreviate(control.getAnnotation());
        final boolean small = name.length() < 2;
        this.label = new JLabel(name, 0){

            public Dimension getMaximumSize() {
                Dimension size = super.getPreferredSize();
                size.width = control.isWidthLimited() ? (small ? 21 : 42) : 128;
                return size;
            }

            public Dimension getMinimumSize() {
                Dimension size = super.getPreferredSize();
                size.width = small ? 18 : 36;
                return size;
            }
        };
        this.label.setAlignmentX(0.5f);
        this.label.setOpaque(true);
        this.update(null, null);
        this.add(this.label);
    }

    public void update(Observable obs, Object arg) {
        boolean val = this.control.getValue();
        this.label.setBackground(val ? this.control.getStateColor(this.control.getValue()) : this.getBackground());
    }
}

