/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.swingui.controlui.ControlPanel;

public class BooleanControlPanel
extends ControlPanel {
    private final BooleanControl control;
    private AbstractButton button;
    private ActionListener buttonListener;

    public BooleanControlPanel(final BooleanControl control) {
        super(control);
        boolean small;
        this.setLayout(new BoxLayout(this, 1));
        this.control = control;
        String name = this.abbreviate(control.getAnnotation());
        boolean bl = small = name.length() < 2;
        if (!control.isMomentary()) {
            this.button = new JButton(name){

                public Dimension getMaximumSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = control.isWidthLimited() ? (small ? 21 : 42) : 128;
                    return size;
                }

                public Dimension getMinimumSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = small ? 18 : 36;
                    return size;
                }
            };
            this.buttonListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    control.setValue(!control.getValue());
                }
            };
        } else {
            this.button = new JButton(name){

                public Dimension getMaximumSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = control.isWidthLimited() ? 45 : 128;
                    return size;
                }
            };
            this.buttonListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    control.momentaryAction();
                }
            };
        }
        this.button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.button.setAlignmentX(0.5f);
        this.button.setBackground(control.getStateColor(control.getValue()));
        this.add(this.button);
    }

    public void update(Observable obs, Object arg) {
        this.button.setBackground(this.control.getStateColor(this.control.getValue()));
    }

    public void addNotify() {
        super.addNotify();
        this.button.addActionListener(this.buttonListener);
    }

    public void removeNotify() {
        this.button.removeActionListener(this.buttonListener);
        super.removeNotify();
    }
}

