/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.mixerui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSelector;
import uk.org.toot.swingui.audioui.AudioCompoundControlPanel;
import uk.org.toot.swingui.audioui.AudioCompoundStripPanel;
import uk.org.toot.swingui.controlui.PanelFactory;

public class MixerSectionPanel
extends AudioCompoundStripPanel {
    protected Observer controlObserver;
    protected int sectionId;
    protected MouseListener mouseHandler;

    public MixerSectionPanel(MixerControls mixerControls, int id, PanelFactory panelFactory) {
        super(mixerControls, panelFactory);
        this.sectionId = id;
        this.controlObserver = new Observer(){

            public void update(Observable obs, Object arg) {
                if (arg == null || arg instanceof MixerControls.Mutation) {
                    SwingUtilities.invokeLater(new Updater(arg));
                }
            }
        };
        this.mouseHandler = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AudioCompoundControlPanel strip = (AudioCompoundControlPanel)e.getComponent();
                MixerSectionPanel.this.setCurrentStripName(strip.getName());
            }
        };
    }

    protected void processMutation(MixerControls.Mutation m) {
        CompoundControl cc = m.getControl();
        if (cc.getId() != this.sectionId) {
            return;
        }
        int op = m.getOperation();
        if (op == 1) {
            this.setupStrip(cc);
        } else if (op == 2) {
            this.reset();
        }
    }

    protected void dispose() {
        this.mouseHandler = null;
        super.dispose();
    }

    protected void setup() {
        this.removeAll();
        int cnt = 0;
        for (Control control : this.controls.getControls()) {
            if (control instanceof CompoundControl && control.getId() != this.sectionId) continue;
            this.setupStrip((CompoundControl)control);
            ++cnt;
        }
    }

    protected void setupStrip(CompoundControl stripControls) {
        FaderPanel faderPanel = new FaderPanel(stripControls, this.controlSelector, this.panelFactory);
        if (this.sectionId != 120) {
            JLabel label = new JLabel(stripControls.getName());
            label.setAlignmentX(0.5f);
            faderPanel.add(label);
        }
        this.add(faderPanel);
    }

    public void addNotify() {
        super.addNotify();
        this.controls.addObserver(this.controlObserver);
    }

    public void removeNotify() {
        this.controls.deleteObserver(this.controlObserver);
        if (this.doDispose) {
            this.controlObserver = null;
        }
        super.removeNotify();
    }

    protected void setCurrentStripName(String name) {
    }

    protected class FaderPanel
    extends AudioCompoundControlPanel {
        public FaderPanel(CompoundControl stripControls, ControlSelector controlSelector, PanelFactory panelFactory) {
            super(stripControls, 1, controlSelector, panelFactory, false, true);
        }

        public void addNotify() {
            super.addNotify();
            this.addMouseListener(MixerSectionPanel.this.mouseHandler);
        }

        public void removeNotify() {
            this.removeMouseListener(MixerSectionPanel.this.mouseHandler);
            super.removeNotify();
        }
    }

    protected class Updater
    implements Runnable {
        private Object obj;

        public Updater(Object o) {
            this.obj = o;
        }

        public void run() {
            if (this.obj == null) {
                MixerSectionPanel.this.reset();
            } else if (this.obj instanceof MixerControls.Mutation) {
                MixerSectionPanel.this.processMutation((MixerControls.Mutation)this.obj);
                MixerSectionPanel.this.revalidate();
                MixerSectionPanel.this.repaint();
            }
        }
    }
}

