/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.mixerui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import uk.org.toot.audio.meter.MeterControls;
import uk.org.toot.audio.mixer.BusControls;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSelector;
import uk.org.toot.localisation.Localisation;
import uk.org.toot.swing.DisposablePanel;
import uk.org.toot.swingui.audioui.meterui.KMeterPanel;
import uk.org.toot.swingui.audioui.mixerui.MixerPanelFactory;
import uk.org.toot.swingui.audioui.mixerui.MixerSectionPanel;
import uk.org.toot.swingui.controlui.PanelFactory;

public class FullMixerPanel
extends DisposablePanel {
    protected MixerControls mixerControls;
    protected ControlSelector controlSelector;
    protected JToolBar toolBar;
    protected JPanel stripsPanel;
    protected MixerSectionPanel channelsPanel;
    protected MixerSectionPanel groupsPanel;
    protected MixerSectionPanel fxPanel;
    protected MixerSectionPanel auxPanel;
    protected MixerSectionPanel masterPanel;
    protected MixerSectionPanel controlsPanel;
    protected KMeterPanel meterPanel;
    protected JLabel statusLabel;
    protected String currentBusName;
    protected PanelFactory panelFactory;
    private Observer statusObserver = null;

    public FullMixerPanel(MixerControls mixerControls) {
        this.mixerControls = mixerControls;
        this.currentBusName = mixerControls.getMainBusControls().getName();
        this.statusLabel = new JLabel("");
        this.statusObserver = new Observer(){

            public void update(Observable obs, Object arg) {
                if (arg != null && arg instanceof Control) {
                    FullMixerPanel.this.updateStatusLabel((Control)arg);
                }
            }
        };
        this.toolBar = new JToolBar();
        this.addTools(this.toolBar);
        this.panelFactory = new MixerPanelFactory(){

            public boolean isFaderRotary(Control c) {
                return !FullMixerPanel.this.currentBusName.startsWith(c.getParent().getName());
            }
        };
        this.channelsPanel = new MixerSectionPanel(mixerControls, 120, this.panelFactory){

            protected void setCurrentStripName(String name) {
                FullMixerPanel.this.setCurrentStripName(name);
            }
        };
        this.groupsPanel = new MixerSectionPanel(mixerControls, 121, this.panelFactory){

            protected void setCurrentStripName(String name) {
                FullMixerPanel.this.setCurrentStripName(name);
            }
        };
        this.fxPanel = new MixerSectionPanel(mixerControls, 122, this.panelFactory){

            protected void setCurrentStripName(String name) {
                FullMixerPanel.this.setCurrentStripName(name);
            }
        };
        this.auxPanel = new MixerSectionPanel(mixerControls, 124, this.panelFactory){

            protected void setCurrentStripName(String name) {
                FullMixerPanel.this.setCurrentStripName(name);
            }
        };
        this.masterPanel = new MixerSectionPanel(mixerControls, 123, this.panelFactory){

            protected void setCurrentStripName(String name) {
                FullMixerPanel.this.setCurrentStripName(name);
            }
        };
        this.controlsPanel = new MixerSectionPanel(mixerControls, -124, this.panelFactory){

            protected void setCurrentStripName(String name) {
                FullMixerPanel.this.setCurrentStripName(name);
            }
        };
        this.meterPanel = new KMeterPanel(mixerControls.getBusControls(this.currentBusName).getMeterControls(), 1);
        this.setLayout(new BorderLayout());
        this.stripsPanel = new JPanel();
        this.stripsPanel.setLayout(new BoxLayout(this.stripsPanel, 0));
        this.setup();
        this.add((Component)this.stripsPanel, "Center");
        this.add((Component)this.toolBar, "North");
    }

    protected void dispose() {
        this.panelFactory = null;
        this.channelsPanel = null;
        this.groupsPanel = null;
        this.fxPanel = null;
        this.auxPanel = null;
        this.masterPanel = null;
        this.controlsPanel = null;
        this.meterPanel.dispose();
        this.meterPanel = null;
        this.stripsPanel.removeAll();
        this.stripsPanel = null;
        this.removeAll();
        this.toolBar.removeAll();
        this.toolBar = null;
        this.controlSelector = null;
    }

    public void addNotify() {
        super.addNotify();
        this.mixerControls.addObserver(this.statusObserver);
    }

    public void removeNotify() {
        this.mixerControls.deleteObserver(this.statusObserver);
        if (this.doDispose) {
            this.statusObserver = null;
        }
        super.removeNotify();
    }

    public void setControlSelector(ControlSelector selector) {
        this.channelsPanel.setControlSelector(selector);
        this.groupsPanel.setControlSelector(selector);
        this.fxPanel.setControlSelector(selector);
        this.auxPanel.setControlSelector(selector);
        this.masterPanel.setControlSelector(selector);
        this.controlSelector = selector;
    }

    protected void updateStatusLabel(Control c) {
        this.statusLabel.setText(String.valueOf(c.getControlPath(this.mixerControls, ", ")) + "  " + c.getValueString());
    }

    protected void addTools(JToolBar bar) {
        bar.add(Box.createGlue());
        bar.add(Box.createHorizontalStrut(20));
        bar.add(this.statusLabel);
        bar.add(Box.createGlue());
        bar.add(new BusCombo(this.mixerControls));
        bar.add(Box.createHorizontalStrut(10));
        this.addSectionButtons(bar);
    }

    protected void setCurrentBusName(String name) {
        this.currentBusName = name;
        this.setControlSelector(this.controlSelector);
        MeterControls mc = this.mixerControls.getBusControls(this.currentBusName).getMeterControls();
        if (mc != null) {
            this.meterPanel.setMeterControls(mc);
        }
    }

    protected void addSectionButtons(JToolBar bar) {
        final String groupsString = Localisation.getString("Groups");
        final String fxString = Localisation.getString("FX");
        final String auxString = Localisation.getString("Aux");
        final JToggleButton groupsButton = new JToggleButton(groupsString, false);
        final JToggleButton fxButton = new JToggleButton(fxString, false);
        final JToggleButton auxButton = new JToggleButton(auxString, false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals(groupsString)) {
                    FullMixerPanel.this.groupsPanel.setVisible(groupsButton.isSelected());
                } else if (cmd.equals(fxString)) {
                    FullMixerPanel.this.fxPanel.setVisible(fxButton.isSelected());
                } else if (cmd.equals(auxString)) {
                    FullMixerPanel.this.auxPanel.setVisible(auxButton.isSelected());
                }
            }
        };
        groupsButton.addActionListener(actionListener);
        fxButton.addActionListener(actionListener);
        auxButton.addActionListener(actionListener);
        bar.add(groupsButton);
        bar.add(fxButton);
        bar.add(auxButton);
    }

    protected void setup() {
        this.groupsPanel.setVisible(false);
        this.fxPanel.setVisible(false);
        this.auxPanel.setVisible(false);
        JScrollPane scrollPane = new JScrollPane(this.channelsPanel, 20, 32);
        int inc = 64;
        scrollPane.getHorizontalScrollBar().setUnitIncrement(inc);
        this.stripsPanel.add(scrollPane);
        this.stripsPanel.add(Box.createHorizontalGlue());
        this.stripsPanel.add(this.groupsPanel);
        this.stripsPanel.add(this.fxPanel);
        this.stripsPanel.add(this.auxPanel);
        this.stripsPanel.add(this.masterPanel);
        this.stripsPanel.add(this.meterPanel);
        this.stripsPanel.add(this.controlsPanel);
    }

    protected void setCurrentStripName(String currentStrip) {
    }

    protected boolean useButtonGroup() {
        return true;
    }

    public class BusCombo
    extends JComboBox {
        public BusCombo(MixerControls mixerControls) {
            this.addItem(mixerControls.getMainBusControls());
            for (BusControls busControls : mixerControls.getFxBusControls()) {
                this.addItem(busControls);
            }
            for (BusControls busControls : mixerControls.getAuxBusControls()) {
                this.addItem(busControls);
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    FullMixerPanel.this.setCurrentBusName(BusCombo.this.getSelectedItem().toString());
                }
            });
        }

        public Dimension getMaximumSize() {
            Dimension size = super.getPreferredSize();
            size.width = 100;
            return size;
        }
    }

    public class SingleBusSelector
    implements ControlSelector {
        public boolean select(Control control) {
            int id = control.getId();
            if (id == 119) {
                return true;
            }
            if (id != 127 && id != 126 && id != 125) {
                return false;
            }
            boolean isCurrentBus = FullMixerPanel.this.currentBusName.startsWith(control.getName());
            return isCurrentBus;
        }
    }

    public static class UserSelector
    implements ControlSelector {
        public boolean select(Control control) {
            return false;
        }
    }
}

