/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

import java.util.Observable;
import uk.org.toot.music.tonality.ChordMode;
import uk.org.toot.music.tonality.Pitch;
import uk.org.toot.music.tonality.Scale;
import uk.org.toot.music.tonality.Scales;

public class Key
extends Observable {
    protected int root;
    protected Scale scale;
    protected String[] names;

    public Key(int root, Scale scale) {
        this.root = Pitch.classValue(root);
        this.scale = scale;
    }

    public Key(String root, Scale scale) {
        this(Pitch.classValue(root), scale);
    }

    public Key(int root) {
        this(root, Scales.getInitialScale());
    }

    public Key() {
        this("C", Scales.getInitialScale());
    }

    public boolean contains(int[] pitches) {
        int i = 0;
        while (i < pitches.length) {
            if (!this.contains(pitches[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(int pitch) {
        return this.index(pitch) >= 0;
    }

    public int index(int pitch) {
        int i = 0;
        while (i < this.scale.length()) {
            if (Pitch.classValue(pitch) == Pitch.classValue(this.getNote(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getNames() {
        return this.names;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public int getRoot() {
        return this.root;
    }

    public void setRoot(int root) {
        this.root = Pitch.classValue(root);
        this.setChanged();
        this.notifyObservers();
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
        this.setChanged();
        this.notifyObservers();
    }

    public int diatonicPitch(int pitch) {
        if (this.contains(pitch)) {
            return pitch;
        }
        int disp = 1;
        while (disp < 3) {
            if (pitch - disp > 0 && this.contains(pitch - disp)) {
                return pitch - disp;
            }
            if (pitch + disp < 128 && this.contains(pitch + disp)) {
                return pitch + disp;
            }
            ++disp;
        }
        return pitch;
    }

    public int getRelativePitch(int pitch, int offset) {
        block4: {
            block3: {
                pitch = this.diatonicPitch(pitch);
                if (offset == 0) {
                    return pitch;
                }
                if (offset >= 0) break block3;
                while (offset < 0 && pitch > 0) {
                    if (!this.contains(--pitch)) continue;
                    ++offset;
                }
                break block4;
            }
            if (offset <= 0) break block4;
            while (offset > 0 && pitch < 127) {
                if (!this.contains(++pitch)) continue;
                --offset;
            }
        }
        return pitch;
    }

    public int getNote(int index) {
        return this.getRoot() + this.getScale().interval(index);
    }

    public int[] getChordNotes(int index, int poly, int lowInterval) {
        int[] notes = new int[poly];
        int[] chordMode = this.getScale().getChordMode(index);
        int[] intervals = ChordMode.getIntervals(chordMode, poly, lowInterval);
        int base = this.getNote(index);
        int n = 0;
        while (n < poly) {
            notes[n] = base + intervals[n];
            ++n;
        }
        return notes;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (o instanceof Key) {
            return this.toString().equals(((Key)o).toString());
        }
        return super.equals(o);
    }

    public String name() {
        return String.valueOf(this.name(0)) + " " + this.scale.getName();
    }

    public String name(int index) {
        if (this.names == null) {
            return Pitch.className(this.getNote(index));
        }
        return this.names[index % this.names.length];
    }

    public static interface Provider {
        public Key getKey();
    }
}

