/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.composition;

import uk.org.toot.music.Note;
import uk.org.toot.music.composition.AbstractComposer;
import uk.org.toot.music.tonality.Key;

public class TonalComposer
extends AbstractComposer {
    private int currentPitch;

    public int[] composeBar(Key key) {
        long timing = this.getContext().createTiming();
        int n = Long.bitCount(timing);
        int[] polys = new int[n];
        int m = 0;
        int i = 0;
        while (i < n) {
            polys[i] = Math.random() >= (double)this.getContext().getMelodyProbability() ? this.getContext().getMinPoly() + (int)(Math.random() * (double)(1 + this.getContext().getMaxPoly() - this.getContext().getMinPoly())) : 1;
            m += polys[i];
            ++i;
        }
        int[] notes = new int[m];
        n = 0;
        m = 0;
        int i2 = 0;
        while (i2 < 64) {
            if ((timing & 1L << i2) != 0L) {
                this.currentPitch = this.getContext().nextPitch(this.currentPitch, key);
                if (polys[n] > 1) {
                    int[] chordNotes = key.getChordNotes(key.index(this.currentPitch), polys[n], 3);
                    int offset = this.currentPitch - chordNotes[0];
                    int p = 0;
                    while (p < polys[n]) {
                        notes[m++] = Note.create(i2, chordNotes[p] + offset, this.getContext().getLevel(i2));
                        ++p;
                    }
                } else {
                    notes[m++] = Note.create(i2, this.currentPitch, this.getContext().getLevel(i2));
                }
                ++n;
            }
            ++i2;
        }
        this.fixupOffTimes(notes);
        return notes;
    }

    protected void fixupOffTimes(int[] notes) {
        int i = 0;
        while (i < notes.length) {
            int note = notes[i];
            int onTime = Note.getTime(note);
            int offTime = 64;
            if (i < notes.length - 1) {
                int j = i + 1;
                while (j < notes.length) {
                    if (Note.getTime(notes[j]) > onTime) {
                        offTime = Note.getTime(notes[j]);
                        break;
                    }
                    ++j;
                }
            }
            int duration = Math.max(1, (int)(this.getContext().getLegato() * (float)(offTime - onTime)));
            notes[i] = Note.setDuration(note, duration);
            ++i;
        }
    }

    public Context getContext() {
        return (Context)super.getContext();
    }

    public static class Context
    extends AbstractComposer.Context {
        private int minPitch;
        private int maxPitch;
        private int maxPitchChange = 3;
        private int minPoly = 3;
        private int maxPoly = 5;
        private float legato = 1.0f;
        private float melodyProbability = 0.0f;
        private float repeatPitchProbability = 0.25f;

        public int nextPitch(int pitch, Key key) {
            if (Math.random() > (double)this.getRepeatPitchProbability()) {
                int offset = (int)((double)(2 * this.getMaxPitchChange() + 1) * Math.random() - (double)this.getMaxPitchChange());
                if (pitch == this.getMinPitch() && offset < 0 || pitch == this.getMaxPitch() && offset > 0) {
                    offset = -offset;
                }
                pitch = key.getRelativePitch(pitch, offset);
            }
            if (pitch < this.getMinPitch() || pitch > this.getMaxPitch()) {
                pitch = this.getMinPitch() + (int)(Math.random() * (double)(this.getMaxPitch() - this.getMinPitch()));
            }
            return key.diatonicPitch(pitch);
        }

        public int getMinPitch() {
            return this.minPitch;
        }

        public void setMinPitch(int minPitch) {
            this.minPitch = minPitch;
        }

        public int getMaxPitch() {
            return this.maxPitch;
        }

        public void setMaxPitch(int maxPitch) {
            this.maxPitch = maxPitch;
        }

        public int getMaxPitchChange() {
            return this.maxPitchChange;
        }

        public void setMaxPitchChange(int maxPitchChange) {
            this.maxPitchChange = maxPitchChange;
        }

        public float getLegato() {
            return this.legato;
        }

        public void setLegato(float legato) {
            this.legato = legato;
        }

        public int getMaxPoly() {
            return this.maxPoly;
        }

        public void setMaxPoly(int maxPoly) {
            this.maxPoly = maxPoly;
        }

        public int getMinPoly() {
            return this.minPoly;
        }

        public void setMinPoly(int minPoly) {
            this.minPoly = minPoly;
        }

        public float getMelodyProbability() {
            return this.melodyProbability;
        }

        public void setMelodyProbability(float melody) {
            this.melodyProbability = melody;
        }

        public float getRepeatPitchProbability() {
            return this.repeatPitchProbability;
        }

        public void setRepeatPitchProbability(float repeatPitchProbability) {
            this.repeatPitchProbability = repeatPitchProbability;
        }
    }
}

