/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.composition;

public class Timing {
    public static final int COUNT = 64;
    public static final long ONE = 1L;
    public static final long ONE_UH = 16L;
    public static final long ONE_AND = 256L;
    public static final long ONE_AND_UH = 4096L;
    public static final long TWO = 65536L;
    public static final long TWO_UH = 0x100000L;
    public static final long TWO_AND = 0x1000000L;
    public static final long TWO_AND_UH = 0x10000000L;
    public static final long THREE = 0x100000000L;
    public static final long THREE_UH = 0x1000000000L;
    public static final long THREE_AND = 0x10000000000L;
    public static final long THREE_AND_UH = 0x100000000000L;
    public static final long FOUR = 0x1000000000000L;
    public static final long FOUR_UH = 0x10000000000000L;
    public static final long FOUR_AND = 0x100000000000000L;
    public static final long FOUR_AND_UH = 0x1000000000000000L;
    public static final long ALL_DOWNBEATS = 0x1000100010001L;
    public static final long EVEN_DOWNBEATS = 0x1000000010000L;
    public static final long ODD_DOWNBEATS = 0x100000001L;
    public static final long ALL_UPBEATS = 0x100010001000100L;
    public static final long EVEN_UPBEATS = 0x100000001000000L;
    public static final long ODD_UPBEATS = 0x10000000100L;

    public static long subdivide(long mask, float density, int minres, int lo, int hi) {
        mask |= 1L << lo;
        int mid = lo + hi >> 1;
        if (Math.random() < (double)density && hi - lo > minres) {
            mask = Timing.subdivide(mask, density, minres, lo, mid);
            mask = Timing.subdivide(mask, density, minres, mid, hi);
        }
        return mask;
    }

    public static long subdivide(float density, int minnotelen) {
        if (minnotelen > 64) {
            minnotelen = 64;
        } else if (minnotelen < 1) {
            minnotelen = 32;
        }
        return Timing.subdivide(0L, density, 64 / minnotelen, 0, 64);
    }

    public static long byProbabilities(int[] probabilities) {
        long timing = 0L;
        int step = 64 / probabilities.length;
        int i = 0;
        int p = 0;
        while (i < 64) {
            if (!(Math.random() > (double)probabilities[p])) {
                timing |= 1L << i;
            }
            i += step;
            ++p;
        }
        return timing;
    }
}

