/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.composition;

import uk.org.toot.music.composition.BarComposer;
import uk.org.toot.music.composition.Timing;

public abstract class AbstractComposer
implements BarComposer {
    private Context context;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public static class Context {
        private int level = 64;
        private float density = 0.9f;
        private int minNoteLen = 16;
        private long jamTiming = 0L;
        private long clearTiming = 0L;
        private long accentTiming = 0L;
        private int accent = 0;
        private int[] probabilities;

        public long createTiming() {
            long timing = 0L;
            int[] probs = this.getTimingProbabilities();
            if (probs == null) {
                timing = this.getJamTiming();
                timing |= Timing.subdivide(this.getDensity(), this.getMinNoteLen());
                timing &= this.getClearTiming() ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                timing = Timing.byProbabilities(probs);
            }
            return timing;
        }

        public int getLevel(int time) {
            int lvl = this.level;
            if (this.accent != 0 && (this.accentTiming & (long)(1 << time)) != 0L) {
                lvl += this.accent;
            }
            if (lvl < 0) {
                lvl = 0;
            } else if (lvl > 127) {
                lvl = 127;
            }
            return lvl;
        }

        public void setLevel(int level) {
            if (level < 0 || level > 127) {
                throw new IllegalArgumentException("require 0 <= level <= 127");
            }
            this.level = level;
        }

        public float getDensity() {
            return this.density;
        }

        public void setDensity(float density) {
            this.density = density;
        }

        public int getMinNoteLen() {
            return this.minNoteLen;
        }

        public void setMinNoteLen(int minnotelen) {
            if (Integer.bitCount(minnotelen) != 1) {
                throw new IllegalArgumentException("minnotelen must be a power of 2, from 1 to 64");
            }
            this.minNoteLen = minnotelen;
        }

        public long getClearTiming() {
            return this.clearTiming;
        }

        public void setClearTiming(long clearTiming) {
            this.clearTiming = clearTiming;
        }

        public long getJamTiming() {
            return this.jamTiming;
        }

        public void setJamTiming(long jamTiming) {
            this.jamTiming = jamTiming;
        }

        public long getAccentTiming() {
            return this.accentTiming;
        }

        public void setAccentTiming(long accentTiming) {
            this.accentTiming = accentTiming;
        }

        public int getAccent() {
            return this.accent;
        }

        public void setAccent(int accent) {
            if (accent < -127 || accent > 127) {
                throw new IllegalArgumentException("require -127 <= accent <= 127");
            }
            this.accent = accent;
        }

        public void setTimingProbabilities(int[] probs) {
            if (probs != null && Integer.bitCount(probs.length) != 1) {
                throw new IllegalArgumentException("probability array should be null or have a power of 2 length");
            }
            this.probabilities = probs;
        }

        public int[] getTimingProbabilities() {
            return this.probabilities;
        }
    }
}

