/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Music
implements Serializable {
    private List<String> voices = new ArrayList<String>();
    private HashSet<Section> sections = new HashSet();
    private HashSet<Composition> compositions = new HashSet();

    public Section createSection(String name, int nbars) {
        Section section = new Section(name, nbars);
        this.sections.add(section);
        return section;
    }

    public void deleteSection(Section section) {
        this.sections.remove(section);
    }

    public Composition createComposition(String name) {
        Composition composition = new Composition(name);
        this.compositions.add(composition);
        return composition;
    }

    public void deleteComposition(Composition composition) {
        this.compositions.remove(composition);
    }

    public Iterator<Section> sectionIterator() {
        return this.sections.iterator();
    }

    public Iterator<Composition> compositionIterator() {
        return this.compositions.iterator();
    }

    public void addVoice(String voice) {
        if (this.voices.contains(voice)) {
            return;
        }
        this.voices.add(voice);
    }

    public void list() {
        System.out.println(String.valueOf(this.voices.size()) + " Voices");
        int v = 0;
        while (v < this.voices.size()) {
            System.out.println(" " + this.voices.get(v));
            ++v;
        }
        System.out.println(String.valueOf(this.sections.size()) + " Sections");
        Iterator<Section> sectionIterator = this.sectionIterator();
        while (sectionIterator.hasNext()) {
            Section section = sectionIterator.next();
            System.out.println(" " + section.getName() + ", " + section.getBarCount() + " bars");
        }
        System.out.println(String.valueOf(this.compositions.size()) + " Compositions");
        Iterator<Composition> compositionIterator = this.compositionIterator();
        while (compositionIterator.hasNext()) {
            Composition composition = compositionIterator.next();
            System.out.println(composition.getName());
            sectionIterator = composition.iterator();
            while (sectionIterator.hasNext()) {
                Section section = sectionIterator.next();
                System.out.println(" " + section.getName() + ", " + section.getBarCount() + " bars");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Section
    implements Serializable {
        private String name;
        private Hashtable<String, int[][]> voices;
        private int[][] keyChanges;
        private int barCount;

        protected Section(String name, int barCount) {
            this.name = name;
            this.barCount = barCount;
            this.voices = new Hashtable();
        }

        public int getBarCount() {
            return this.barCount;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNotes(String voice, int bar, int[] barNotes) {
            Music.this.addVoice(voice);
            int[][] notes = this.voices.get(voice);
            if (notes == null) {
                notes = new int[this.barCount][];
            }
            notes[bar] = barNotes;
        }

        public int[] getNotes(String voice, int bar) {
            int[][] notes = this.voices.get(voice);
            if (notes == null) {
                return null;
            }
            return notes[bar];
        }

        public Enumeration<String> getVoices() {
            return this.voices.keys();
        }

        public void setKeyChanges(int bar, int[] barKeys) {
            if (this.keyChanges == null) {
                this.keyChanges = new int[this.barCount][];
            }
            this.keyChanges[bar] = barKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Composition
    implements Serializable {
        private String name;
        private List<Section> sections;

        protected Composition(String name) {
            this.name = name;
            this.sections = new ArrayList<Section>();
        }

        public boolean add(Section section) {
            return this.sections.add(section);
        }

        public void add(int index, Section section) {
            this.sections.add(index, section);
        }

        public Section get(int index) {
            return this.sections.get(index);
        }

        public Section remove(int index) {
            return this.sections.remove(index);
        }

        public int size() {
            return this.sections.size();
        }

        public Iterator<Section> iterator() {
            return this.sections.iterator();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

