/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.misc;

public class Controller {
    public static final int BANK_SELECT = 0;
    public static final int MODULATION = 1;
    public static final int BREATH = 2;
    public static final int CONTROLLER_3 = 3;
    public static final int FOOT = 4;
    public static final int PORTAMENTO = 5;
    public static final int DATA_ENTRY = 6;
    public static final int VOLUME = 7;
    public static final int BALANCE = 8;
    public static final int CONTROLLER_9 = 9;
    public static final int PAN = 10;
    public static final int EXPRESSION = 11;
    public static final int FX_1 = 12;
    public static final int FX_2 = 13;
    public static final int HOLD_PEDAL = 64;
    public static final int PORTAMENTO_SWITCH = 65;
    public static final int SUSTENUTO_PEDAL = 66;
    public static final int SOFT_PEDAL = 67;
    public static final int LEGATO = 68;
    public static final int HOLD_2_PEDAL = 69;
    public static final int VARIATION = 70;
    public static final int TIMBRE = 71;
    public static final int RELEASE = 72;
    public static final int ATTACK = 73;
    public static final int BRIGHTNESS = 74;
    public static final int EXTERNAL_FX = 91;
    public static final int TREMELO = 92;
    public static final int CHORUS = 93;
    public static final int DETUNE = 94;
    public static final int PHASER = 95;
    public static final int DATA_INCREMENT = 96;
    public static final int DATA_DECREMENT = 97;
    public static final int NON_REGISTERED_FINE = 98;
    public static final int NON_REGISTERED_COARSE = 99;
    public static final int REGISTERED_FINE = 100;
    public static final int REGISTERED_COARSE = 101;
    public static final int ALL_SOUND_OFF = 120;
    public static final int ALL_CONTROLLERS_OFF = 121;
    public static final int LOCAL_CONTROL = 122;
    public static final int ALL_NOTES_OFF = 123;
    public static final int OMNI_MODE_OFF = 124;
    public static final int OMNI_MODE_ON = 125;
    public static final int MONO_MODE = 126;
    public static final int POLY_MODE = 127;
    public static final int SWITCHES = 301;
    public static final int PITCH_BEND_PSEUDO = -224;
    public static final int POLY_PRESSURE_PSEUDO = -160;
    public static final int CHANNEL_PRESSURE_PSEUDO = -208;
    public static final int PROGRAM_PSEUDO = -192;
    public static final int[] PERFORMANCE_CONTROLLERS = new int[]{-224, -208, 1, 2, 4, 5, 11, 301};
    public static final int[] SOUND_CONTROLLERS = new int[]{-192, 70, 71, 74, 73, 72};
    public static final int[] MIXER_CONTROLLERS = new int[]{7, 10, 8, 12, 13};
    public static final int[] EFFECTS_CONTROLLERS = new int[]{91, 92, 93, 94, 95};
    public static final int[] UNDEFINED_CONTROLLERS = new int[]{3, 9, 14, 15};
    public static final int[] NO_CONTROLLERS = new int[0];
    public static final int[] SWITCH_CONTROLLERS = new int[]{64, 65, 66, 67, 68, 69};
    private static final String[] CATEGORIES = new String[]{"Performance", "Sound", "Mixer", "Effects", "Undefined"};

    public static String[] getCategories() {
        return CATEGORIES;
    }

    public static int[] getControllers(String category) {
        if ("Performance".equals(category)) {
            return PERFORMANCE_CONTROLLERS;
        }
        if ("Sound".equals(category)) {
            return SOUND_CONTROLLERS;
        }
        if ("Mixer".equals(category)) {
            return MIXER_CONTROLLERS;
        }
        if ("Effects".equals(category)) {
            return EFFECTS_CONTROLLERS;
        }
        if ("Undefined".equals(category)) {
            return UNDEFINED_CONTROLLERS;
        }
        return NO_CONTROLLERS;
    }

    public static String propertyName(int controller) {
        switch (controller) {
            case 301: {
                return "Switches";
            }
            case -224: {
                return "Pitch Bend";
            }
            case -160: {
                return "Poly Pressure";
            }
            case -208: {
                return "Channel Pressure";
            }
            case -192: {
                return "Program";
            }
            case 0: {
                return "Bank Select";
            }
            case 1: {
                return "Modulation";
            }
            case 2: {
                return "Breath";
            }
            case 4: {
                return "Foot";
            }
            case 5: {
                return "Portamento";
            }
            case 6: {
                return "Data Entry";
            }
            case 7: {
                return "Volume";
            }
            case 8: {
                return "Balance";
            }
            case 10: {
                return "Pan";
            }
            case 11: {
                return "Expression";
            }
            case 12: {
                return "Effect 1";
            }
            case 13: {
                return "Effect 2";
            }
            case 64: {
                return "Hold Pedal";
            }
            case 65: {
                return "Portamento Switch";
            }
            case 66: {
                return "Sustenuto Pedal";
            }
            case 67: {
                return "Soft Pedal";
            }
            case 68: {
                return "Legato";
            }
            case 69: {
                return "Hold2 Pedal";
            }
            case 70: {
                return "Variation";
            }
            case 71: {
                return "Timbre";
            }
            case 72: {
                return "Release";
            }
            case 73: {
                return "Attack";
            }
            case 74: {
                return "Brightness";
            }
            case 91: {
                return "External Effects";
            }
            case 92: {
                return "Tremelo";
            }
            case 93: {
                return "Chorus";
            }
            case 94: {
                return "Detune";
            }
            case 95: {
                return "Phaser";
            }
            case 96: {
                return "Data Increment";
            }
            case 97: {
                return "Data Decrement";
            }
            case 98: {
                return "NRPN fine";
            }
            case 99: {
                return "NRPN coarse";
            }
            case 100: {
                return "RPN fine";
            }
            case 101: {
                return "RPN coarse";
            }
            case 120: {
                return "All Sound Off";
            }
            case 121: {
                return "All Controllers Off";
            }
            case 122: {
                return "Local Control";
            }
            case 123: {
                return "All Notes Off";
            }
            case 124: {
                return "Omni Off";
            }
            case 125: {
                return "Omni On";
            }
            case 126: {
                return "Mono";
            }
            case 127: {
                return "Poly";
            }
        }
        return "Controller " + String.valueOf(controller);
    }

    public static boolean is7bit(int controller) {
        return controller >= 64 || controller < 0 && controller != -224;
    }

    public static int getMinimum(int controller) {
        return 0;
    }

    public static int getMaximum(int controller) {
        return -1 + (Controller.is7bit(controller) ? 128 : 16384);
    }

    public static int getDefault(int controller) {
        switch (controller) {
            case 7: {
                return 12800;
            }
            case 11: {
                return Controller.getMaximum(controller);
            }
            case -224: 
            case 8: 
            case 10: {
                return (Controller.getMaximum(controller) + 1) / 2;
            }
        }
        return 0;
    }

    public static int getOffset(int controller) {
        return controller == 10 || controller == 8 || controller == -224 ? (Controller.getMaximum(controller) + 1) / 2 : 0;
    }

    public static int getOrientation(int controller) {
        if (controller == 10 || controller == 8) {
            return 0;
        }
        return 1;
    }
}

