/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Track;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSysexMsg;

public class MidiPersistence {
    private MidiPersistence() {
    }

    public static void store(int providerId, int moduleId, int instanceIndex, CompoundControl parent, Track t) {
        Control[] controlArray = parent.getMemberControls();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            Control c = controlArray[n];
            if (c instanceof CompoundControl) {
                MidiPersistence.store(providerId, moduleId, instanceIndex, (CompoundControl)c, t);
            } else {
                try {
                    if (!c.isIndicator() && c.getId() > 0) {
                        MidiMessage msg = ControlSysexMsg.createControl(providerId, moduleId, instanceIndex, c.getId(), c.getIntValue());
                        t.add(new MidiEvent(msg, 0L));
                    }
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }
}

