/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.awt.Color;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlLaw;

public class LawControl
extends Control {
    private ControlLaw law;
    private float value;
    private float precision;
    private Color insertColor;
    private String valueFormat;

    public LawControl(int id, String name, ControlLaw law, float precision, float initialValue) {
        super(id, name);
        this.law = law;
        this.precision = precision;
        this.value = initialValue;
        this.valueFormat = "%1$." + this.calculateDecimalPlaces() + "f %2$s";
    }

    protected int calculateDecimalPlaces() {
        return this.law.getMaximum() - this.law.getMinimum() > 100.0f ? 1 : 2;
    }

    public ControlLaw getLaw() {
        return this.law;
    }

    public float getValue() {
        return this.value;
    }

    public String getValueString() {
        return String.format(this.valueFormat, Float.valueOf(this.getValue()), this.getLaw().getUnits());
    }

    public void setValue(float value) {
        this.value = value;
        this.notifyParent(this);
    }

    public float getPrecision() {
        return this.precision;
    }

    public Color getInsertColor() {
        return this.insertColor;
    }

    public void setInsertColor(Color insertColor) {
        this.insertColor = insertColor;
    }

    public void setIntValue(int value) {
        this.setValue(this.getLaw().userValue(value));
    }

    public int getIntValue() {
        return this.getLaw().intValue(this.getValue());
    }

    public String[] getPresetNames() {
        return null;
    }

    public void applyPreset(String name) {
    }
}

