/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.message.SysexMsg;

public class ControlSysexMsg
extends SysexMsg {
    private static final int LENGTH = 8;

    public static boolean isControl(MidiMessage msg) {
        return ControlSysexMsg.isControl(ControlSysexMsg.getMessage(msg));
    }

    public static boolean isControl(byte[] data) {
        return data[0] == -16 && data[1] == 125 && data.length == 8;
    }

    public static MidiMessage createControl(int providerId, int moduleId, int instanceIndex, int controlId, int value) throws InvalidMidiDataException {
        if (instanceIndex > 7) {
            throw new InvalidMidiDataException("Instance index " + instanceIndex + " MUST be < 8");
        }
        byte[] data = new byte[]{-16, 125, (byte)(providerId & 0x7F), (byte)(moduleId & 0x7F), (byte)(instanceIndex & 7), (byte)(controlId & 0x7F), (byte)(value & 0x7F), (byte)(value >> 7 & 0x7F)};
        MidiMessage msg = ControlSysexMsg.createSysex(data, 8);
        assert (ControlSysexMsg.isControl(msg));
        return msg;
    }

    public static int getProviderId(MidiMessage msg) {
        return ControlSysexMsg.getMessage(msg)[2] & 0x7F;
    }

    public static int getModuleId(MidiMessage msg) {
        return ControlSysexMsg.getMessage(msg)[3] & 0x7F;
    }

    public static int getInstanceIndex(MidiMessage msg) {
        return ControlSysexMsg.getMessage(msg)[4] & 0x7F;
    }

    public static int getControlId(MidiMessage msg) {
        return ControlSysexMsg.getMessage(msg)[5] & 0x7F;
    }

    public static int getValue(MidiMessage msg) {
        byte[] data = ControlSysexMsg.getMessage(msg);
        return data[6] + 128 * data[7];
    }
}

