/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import uk.org.toot.control.Control;

public interface ControlSelector {
    public boolean select(Control var1);

    public static class Not
    implements ControlSelector {
        private ControlSelector selector;

        public Not(ControlSelector selector) {
            this.selector = selector;
        }

        public boolean select(Control control) {
            return !this.selector.select(control);
        }
    }

    public static abstract class LogicalBinary
    implements ControlSelector {
        protected ControlSelector a;
        protected ControlSelector b;

        public LogicalBinary(ControlSelector a, ControlSelector b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class Or
    extends LogicalBinary {
        public Or(ControlSelector a, ControlSelector b) {
            super(a, b);
        }

        public boolean select(Control control) {
            return this.a.select(control) || this.b.select(control);
        }
    }
}

