/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.audio.server.IOAudioProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonRealTimeAudioServer
implements AudioServer,
AudioClient,
Runnable {
    private boolean realTime = true;
    private boolean isRunning = false;
    private AudioServer server;
    private AudioClient client;
    private List<AudioBuffer> buffers = new ArrayList<AudioBuffer>();
    private Thread thread;
    private boolean startASAP = false;

    public NonRealTimeAudioServer(AudioServer server) {
        this.server = server;
    }

    public void setRealTime(boolean rt) {
        if (!this.isRunning()) {
            this.realTime = rt;
            return;
        }
        if (this.realTime != rt) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.realTime = rt;
            for (AudioBuffer buffer : this.buffers) {
                buffer.setRealTime(this.realTime);
            }
            try {
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isRealTime() {
        return this.realTime;
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (this.realTime) {
            this.server.start();
        } else {
            this.startNRT();
        }
    }

    protected void startNRT() {
        if (this.client == null) {
            this.startASAP = true;
            return;
        }
        System.out.println("NonRealTimeAudioServer starting");
        this.thread = new Thread((Runnable)this, "NonRealTimeAudioServer");
        this.thread.start();
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        if (this.realTime) {
            this.server.stop();
        } else if (this.isRunning) {
            this.stopNRT();
        }
    }

    protected void stopNRT() {
        System.out.println("NonRealTimeAudioServer stopping");
        this.isRunning = false;
    }

    @Override
    public void setClient(AudioClient client) {
        this.server.setClient(this);
        this.client = client;
        if (this.startASAP) {
            this.startASAP = false;
            this.start();
        }
    }

    @Override
    public boolean isRunning() {
        return this.realTime ? this.server.isRunning() : this.isRunning;
    }

    @Override
    public float getLoad() {
        return this.realTime ? this.server.getLoad() : (this.isRunning ? 1.0f : 0.0f);
    }

    @Override
    public void setEnabled(boolean enable) {
    }

    @Override
    public void work(int nFrames) {
        this.client.work(nFrames);
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            this.work(this.buffers.get(0).getSampleCount());
            Thread.yield();
        }
    }

    @Override
    public AudioBuffer createAudioBuffer(String name) {
        AudioBuffer buffer = this.server.createAudioBuffer(name);
        this.buffers.add(buffer);
        return buffer;
    }

    @Override
    public List<String> getAvailableOutputNames() {
        return this.server.getAvailableOutputNames();
    }

    @Override
    public List<String> getAvailableInputNames() {
        return this.server.getAvailableInputNames();
    }

    @Override
    public IOAudioProcess openAudioOutput(String name, String label) throws Exception {
        return this.server.openAudioOutput(name, label);
    }

    @Override
    public IOAudioProcess openAudioInput(String name, String label) throws Exception {
        return this.server.openAudioInput(name, label);
    }

    @Override
    public void closeAudioOutput(IOAudioProcess output) {
        this.server.closeAudioOutput(output);
    }

    @Override
    public void closeAudioInput(IOAudioProcess input) {
        this.server.closeAudioInput(input);
    }

    @Override
    public float getSampleRate() {
        return this.server.getSampleRate();
    }

    @Override
    public void setSampleRate(float sampleRate) {
    }

    @Override
    public int getInputLatencyFrames() {
        return this.server.getInputLatencyFrames();
    }

    @Override
    public int getOutputLatencyFrames() {
        return this.server.getOutputLatencyFrames();
    }

    @Override
    public int getTotalLatencyFrames() {
        return this.server.getTotalLatencyFrames();
    }
}

