/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer.automation;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.AudioServices;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.automation.AutomationControls;
import uk.org.toot.audio.mixer.automation.BasicSnapshotAutomation;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSysexMsg;
import uk.org.toot.control.MidiPersistence;
import uk.org.toot.midi.message.MetaMsg;
import uk.org.toot.midi.message.NoteMsg;
import uk.org.toot.midi.message.ShortMsg;

public abstract class MixerControlsMidiSequenceSnapshotAutomation
extends BasicSnapshotAutomation {
    public MixerControlsMidiSequenceSnapshotAutomation(MixerControls controls) {
        super(controls);
    }

    protected void configureSequence(Sequence snapshot) {
        Track[] tracks = snapshot.getTracks();
        int t = 0;
        while (t < tracks.length) {
            block20: {
                AutomationControls autoc;
                AudioControlsChain stripControls;
                String stripName;
                MidiMessage msg;
                Track track;
                block21: {
                    int stripId;
                    track = tracks[t];
                    msg = track.get(0).getMessage();
                    if (!MetaMsg.isMeta(msg)) break block20;
                    stripName = MetaMsg.getString(msg);
                    stripControls = this.mixerControls.getStripControls(stripName);
                    if (stripControls != null) break block21;
                    msg = track.get(1).getMessage();
                    if (!NoteMsg.isNote(msg) || (stripId = ShortMsg.getData1(msg)) != 120 && stripId != 121) break block20;
                    int stripInstanceIndex = ShortMsg.getData2(msg);
                    stripControls = this.mixerControls.createStripControls(stripId, stripInstanceIndex, stripName);
                }
                if ((autoc = stripControls.find(AutomationControls.class)) == null || autoc.canRecall()) {
                    stripControls.setMutating(true);
                    ArrayList<AutomationIndices> needed = new ArrayList<AutomationIndices>();
                    int i = 2;
                    while (i < track.size()) {
                        AutomationIndices triple;
                        msg = track.get(i).getMessage();
                        if (ControlSysexMsg.isControl(msg) && !needed.contains(triple = new AutomationIndices(ControlSysexMsg.getProviderId(msg), ControlSysexMsg.getModuleId(msg), ControlSysexMsg.getInstanceIndex(msg)))) {
                            needed.add(triple);
                        }
                        ++i;
                    }
                    ArrayList<String> deletions = new ArrayList<String>();
                    for (Control c : stripControls.getControls()) {
                        AutomationIndices triple;
                        CompoundControl cc;
                        if (!(c instanceof CompoundControl) || !(cc = (CompoundControl)c).canBeDeleted() || needed.contains(triple = new AutomationIndices(cc.getProviderId(), cc.getId(), cc.getInstanceIndex()))) continue;
                        deletions.add(cc.getName());
                    }
                    for (String s : deletions) {
                        stripControls.delete(s);
                    }
                    int size = stripControls.getControls().size();
                    int i2 = 1;
                    while (i2 < size) {
                        CompoundControl cc2;
                        CompoundControl cc1 = (CompoundControl)stripControls.getControls().get(i2 - 1);
                        if (cc1.canBeMovedBefore() && (cc2 = (CompoundControl)stripControls.getControls().get(i2)).canBeMoved()) {
                            AutomationIndices ti1 = new AutomationIndices(cc1);
                            AutomationIndices ti2 = new AutomationIndices(cc2);
                            int ni1 = needed.indexOf(ti1);
                            int ni2 = needed.indexOf(ti2);
                            if (ni2 > 0 && ni1 > ni2) {
                                stripControls.move(cc2.getName(), cc1.getName());
                            }
                        }
                        ++i2;
                    }
                    int ii = 0;
                    boolean missing = true;
                    while (missing && ii < 10) {
                        missing = false;
                        int n = 0;
                        int a = 0;
                        while (n < needed.size()) {
                            CompoundControl cc = a >= stripControls.getControls().size() ? null : (CompoundControl)stripControls.getControls().get(a);
                            AutomationIndices tin = (AutomationIndices)needed.get(n);
                            if (cc != null) {
                                AutomationIndices tia = new AutomationIndices(cc);
                                if (tia.equals(tin)) {
                                    ++a;
                                    ++n;
                                    continue;
                                }
                                if (!cc.canBeInsertedBefore()) {
                                    ++a;
                                    continue;
                                }
                            }
                            if (tin.getInstanceIndex() != ii) {
                                missing = true;
                                ++n;
                                continue;
                            }
                            String name = AudioServices.lookupModuleName(tin.getProviderId(), tin.getModuleId());
                            if (name == null || name.length() == 0) {
                                ++n;
                                continue;
                            }
                            stripControls.insert(name, cc == null ? null : cc.getName());
                            ++n;
                            ++a;
                        }
                        ++ii;
                    }
                    if (stripControls.getControls().size() < needed.size()) {
                        System.err.println(String.valueOf(stripName) + ": only configured " + stripControls.getControls().size() + " of " + needed.size() + " needed modules");
                    }
                    stripControls.setMutating(false);
                }
            }
            ++t;
        }
    }

    protected void recallSequence(Sequence snapshot) {
        Track[] tracks = snapshot.getTracks();
        int providerId = 0;
        int moduleId = 0;
        int instanceIndex = -1;
        CompoundControl module = null;
        int t = 0;
        while (t < tracks.length) {
            Track track = tracks[t];
            MidiMessage msg = track.get(0).getMessage();
            if (!MetaMsg.isMeta(msg)) {
                System.out.println("recall: no name in track " + t);
            } else {
                String stripName = MetaMsg.getString(msg);
                AudioControlsChain cc = this.mixerControls.getStripControls(stripName);
                if (cc == null || !(cc instanceof AudioControlsChain)) {
                    System.out.println("recall: no strip named " + stripName);
                } else {
                    AudioControlsChain strip = cc;
                    AutomationControls autoc = strip.find(AutomationControls.class);
                    if (autoc == null || autoc.canRecall()) {
                        module = null;
                        int i = 1;
                        while (i < track.size()) {
                            msg = track.get(i).getMessage();
                            if (ControlSysexMsg.isControl(msg)) {
                                int pid = ControlSysexMsg.getProviderId(msg);
                                int mid = ControlSysexMsg.getModuleId(msg);
                                int ii = ControlSysexMsg.getInstanceIndex(msg);
                                int cid = ControlSysexMsg.getControlId(msg);
                                if (module == null || pid != providerId || mid != moduleId || ii != instanceIndex) {
                                    module = strip.find(pid, mid, ii);
                                    providerId = pid;
                                    moduleId = mid;
                                    instanceIndex = ii;
                                }
                                if (module == null) {
                                    System.out.println("recall: no module " + providerId + "/" + moduleId + "/" + instanceIndex + " in " + stripName);
                                } else {
                                    int newValue;
                                    Control control = module.deepFind(cid);
                                    if (control != null && (newValue = ControlSysexMsg.getValue(msg)) != control.getIntValue()) {
                                        control.setIntValue(newValue);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
            ++t;
        }
    }

    protected Sequence storeSequence(String name) {
        Sequence snapshot;
        try {
            snapshot = new Sequence(0.0f, 1);
        }
        catch (InvalidMidiDataException imde) {
            return null;
        }
        int providerId = -1;
        int moduleId = -1;
        int instanceIndex = -1;
        Control[] controlArray = this.mixerControls.getMemberControls();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            AudioControlsChain strip;
            AutomationControls autoc;
            Control c = controlArray[n];
            if (c.getId() >= 0 && ((autoc = (strip = (AudioControlsChain)c).find(AutomationControls.class)) == null || autoc.canStore())) {
                Track t = snapshot.createTrack();
                try {
                    MidiMessage msg = MetaMsg.createMeta(3, strip.getName());
                    t.add(new MidiEvent(msg, 0L));
                    msg = NoteMsg.off(0, strip.getId(), strip.getInstanceIndex());
                    t.add(new MidiEvent(msg, 0L));
                }
                catch (InvalidMidiDataException imde) {
                    System.out.println("store: error storing strip " + strip.getName());
                }
                Control[] controlArray2 = ((CompoundControl)c).getMemberControls();
                int n3 = 0;
                int n4 = controlArray2.length;
                while (n3 < n4) {
                    Control m = controlArray2[n3];
                    CompoundControl cc = (CompoundControl)m;
                    providerId = cc.getProviderId();
                    moduleId = cc.getId();
                    instanceIndex = cc.getInstanceIndex();
                    MidiPersistence.store(providerId, moduleId, instanceIndex, cc, t);
                    ++n3;
                }
            }
            ++n;
        }
        return snapshot;
    }

    public static class AutomationIndices {
        private int providerId;
        private int moduleId;
        private int instanceIndex;

        public AutomationIndices(int vId, int mId, int iIndex) {
            this.providerId = vId;
            this.moduleId = mId;
            this.instanceIndex = iIndex;
        }

        public AutomationIndices(CompoundControl cc) {
            this(cc.getProviderId(), cc.getId(), cc.getInstanceIndex());
        }

        public int getProviderId() {
            return this.providerId;
        }

        public int getModuleId() {
            return this.moduleId;
        }

        public int getInstanceIndex() {
            return this.instanceIndex;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AutomationIndices)) {
                return false;
            }
            AutomationIndices ti = (AutomationIndices)obj;
            return ti.getProviderId() == this.getProviderId() && ti.getModuleId() == this.getModuleId() && ti.getInstanceIndex() == this.getInstanceIndex();
        }

        public int hashCode() {
            return this.providerId ^ this.moduleId ^ this.instanceIndex;
        }
    }
}

