/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer.automation;

import java.awt.Color;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.localisation.Localisation;

public class AutomationControls
extends AudioControls {
    public static final int AUTOMATION_ID = 119;
    public static final int AUTOMATION_READ_ID = -1;
    public static final int AUTOMATION_WRITE_ID = -2;
    public static final int AUTOMATION_RECALL_ID = -3;
    public static final int AUTOMATION_STORE_ID = -4;
    private BooleanControl readControl;
    private BooleanControl writeControl;
    private BooleanControl recallControl;
    private BooleanControl storeControl;

    protected AutomationControls() {
        super(119, "Auto");
    }

    public void ensureDynamicControls() {
        if (this.readControl != null) {
            return;
        }
        CompoundControl.ControlRow readWrite = new CompoundControl.ControlRow();
        this.readControl = new ReadControl();
        readWrite.add(this.readControl);
        this.writeControl = new WriteControl();
        readWrite.add(this.writeControl);
        this.add(readWrite);
    }

    public void ensureSnapshotControls() {
        if (this.recallControl != null) {
            return;
        }
        CompoundControl.ControlRow recallStore = new CompoundControl.ControlRow();
        this.recallControl = new RecallControl();
        recallStore.add(this.recallControl);
        this.storeControl = new StoreControl();
        recallStore.add(this.storeControl);
        this.add(recallStore);
    }

    public boolean canRead() {
        if (this.readControl == null) {
            return true;
        }
        return this.readControl.getValue();
    }

    public boolean canWrite() {
        if (this.writeControl == null) {
            return true;
        }
        return this.writeControl.getValue();
    }

    public boolean canRecall() {
        if (this.recallControl == null) {
            return true;
        }
        return this.recallControl.getValue();
    }

    public boolean canStore() {
        if (this.storeControl == null) {
            return true;
        }
        return this.storeControl.getValue();
    }

    public boolean canBeDeleted() {
        return false;
    }

    public boolean canBeMoved() {
        return false;
    }

    public boolean canBeMovedBefore() {
        return false;
    }

    public boolean canBeInsertedBefore() {
        return false;
    }

    public boolean isAlwaysVertical() {
        return true;
    }

    private static class ReadControl
    extends BooleanControl {
        public ReadControl() {
            super(-1, Localisation.getString("Read"), false);
            this.setAnnotation(this.getName().substring(0, 1).toLowerCase());
            this.setStateColor(true, Color.YELLOW);
        }
    }

    private static class WriteControl
    extends BooleanControl {
        public WriteControl() {
            super(-2, Localisation.getString("Write"), false);
            this.setAnnotation(this.getName().substring(0, 1).toLowerCase());
            this.setStateColor(true, Color.RED);
        }
    }

    private static class RecallControl
    extends BooleanControl {
        public RecallControl() {
            super(-3, Localisation.getString("Recall"), true);
            this.setAnnotation(this.getName().substring(0, 1));
            this.setStateColor(true, new Color(255, 255, 175));
        }
    }

    private static class StoreControl
    extends BooleanControl {
        public StoreControl() {
            super(-4, Localisation.getString("Store.As"), true);
            this.setAnnotation(this.getName().substring(0, 1));
            this.setStateColor(true, Color.pink);
        }
    }
}

