/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import java.util.List;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.mixer.BusControls;
import uk.org.toot.audio.mixer.MainMixControls;
import uk.org.toot.audio.mixer.MixControls;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.PostFadeMixControls;
import uk.org.toot.localisation.Localisation;

public class MixerControlsFactory {
    public static void createBusses(MixerControls mixerControls, int nsends, int naux) {
        String base = Localisation.getString("FX");
        int i = 0;
        while (i < nsends) {
            mixerControls.createFxBusControls(String.valueOf(base) + '#' + (1 + i), ChannelFormat.STEREO);
            ++i;
        }
        base = Localisation.getString("Aux");
        i = 0;
        while (i < naux) {
            mixerControls.createAuxBusControls(String.valueOf(base) + '#' + (1 + i), ChannelFormat.STEREO);
            ++i;
        }
    }

    public static void createBusStrips(MixerControls mixerControls) {
        MixerControlsFactory.createBusStrips(mixerControls, "L-R", ChannelFormat.STEREO, mixerControls.getFxBusControls().size());
    }

    public static void createBusStrips(MixerControls mixerControls, String mainStripName, ChannelFormat mainFormat, int nreturns) {
        mixerControls.createStripControls(123, 0, mainStripName, mainFormat);
        List<BusControls> busControlsList = mixerControls.getAuxBusControls();
        int naux = busControlsList.size();
        int i = 0;
        while (i < naux) {
            mixerControls.createStripControls(124, i, busControlsList.get(i).getName(), false, busControlsList.get(i).getChannelFormat());
            ++i;
        }
        busControlsList = mixerControls.getFxBusControls();
        int nsends = busControlsList.size();
        int i2 = 0;
        while (i2 < nsends) {
            mixerControls.createStripControls(122, i2, busControlsList.get(i2).getName(), i2 < nreturns, busControlsList.get(i2).getChannelFormat());
            ++i2;
        }
    }

    public static void createGroupStrips(MixerControls mixerControls, int ngroups) {
        ChannelFormat mainFormat = mixerControls.getMainBusControls().getChannelFormat();
        int i = 0;
        while (i < ngroups) {
            mixerControls.createStripControls(121, i, String.valueOf((char)(65 + i)), mainFormat);
            ++i;
        }
    }

    public static void createChannelStrips(MixerControls mixerControls, int nchannels) {
        ChannelFormat mainFormat = mixerControls.getMainBusControls().getChannelFormat();
        int i = 0;
        while (i < nchannels) {
            mixerControls.createStripControls(120, i, String.valueOf(1 + i), mainFormat);
            ++i;
        }
    }

    static void addMixControls(MixerControls mixerControls, AudioControlsChain controls, final boolean hasMixControls) {
        MixControls masterControls;
        BusControls busControls;
        int stripId = controls.getId();
        if (stripId == 122) {
            busControls = mixerControls.getBusControls(controls.getName());
            if (busControls != null) {
                masterControls = new MixControls(mixerControls, stripId, busControls, true){

                    public boolean canBeInsertedBefore() {
                        return !hasMixControls;
                    }

                    public boolean canBeMovedBefore() {
                        return !hasMixControls;
                    }

                    public boolean canBeMoved() {
                        return !hasMixControls;
                    }
                };
                controls.add(masterControls);
            }
        } else if (stripId == 124 && (busControls = mixerControls.getBusControls(controls.getName())) != null) {
            masterControls = new MixControls(mixerControls, stripId, busControls, true);
            controls.add(masterControls);
        }
        MainMixControls mainMixControls = new MainMixControls(mixerControls, stripId, mixerControls.getMainBusControls(), stripId == 123);
        if (stripId != 123 && stripId != 124) {
            for (BusControls busControls2 : mixerControls.getAuxBusControls()) {
                if (!hasMixControls) continue;
                controls.add(new MixControls(mixerControls, stripId, busControls2, false));
            }
            if (stripId != 122) {
                for (BusControls busControls2 : mixerControls.getFxBusControls()) {
                    controls.add(new PostFadeMixControls(mixerControls, stripId, busControls2, mainMixControls));
                }
            }
        }
        if (hasMixControls) {
            controls.add(mainMixControls);
        }
    }
}

