/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.core.SimpleAudioProcess;
import uk.org.toot.audio.mixer.AudioMixerStrip;
import uk.org.toot.audio.mixer.MixVariables;

public class MixProcess
extends SimpleAudioProcess {
    protected MixVariables vars;
    protected AudioMixerStrip routedStrip;
    private float gain = 1.0f;
    private float[] channelGains;
    private float[] smoothedChannelGains;
    private float factor = 0.05f;

    public MixProcess(AudioMixerStrip strip, MixVariables vars) {
        if (strip == null) {
            throw new IllegalArgumentException("null strip to route to");
        }
        this.routedStrip = strip;
        this.vars = vars;
        ChannelFormat format = vars.getChannelFormat();
        this.channelGains = new float[format.getCount()];
        this.smoothedChannelGains = new float[format.getCount()];
    }

    protected AudioMixerStrip getRoutedStrip() {
        return this.routedStrip;
    }

    public int processAudio(AudioBuffer buffer) {
        if (!this.vars.isEnabled() && this.vars.isMaster()) {
            buffer.makeSilence();
        } else if (this.vars.isEnabled()) {
            this.gain = this.vars.getGain();
            if (this.gain > 0.0f || this.vars.isMaster()) {
                this.vars.getChannelGains(this.channelGains);
                int c = 0;
                while (c < this.channelGains.length) {
                    int n = c;
                    this.smoothedChannelGains[n] = this.smoothedChannelGains[n] + this.factor * (this.channelGains[c] - this.smoothedChannelGains[c]);
                    ++c;
                }
                this.getRoutedStrip().mix(buffer, this.smoothedChannelGains);
            }
        }
        return 0;
    }
}

