/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import java.awt.Color;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.fader.FaderControl;
import uk.org.toot.audio.fader.FaderLaw;
import uk.org.toot.audio.mixer.BusControls;
import uk.org.toot.audio.mixer.MixVariables;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.EnumControl;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.localisation.Localisation;

public class MixControls
extends AudioControls
implements MixVariables {
    private static final float HALF_ROOT_TWO = (float)(Math.sqrt(2.0) / 2.0);
    private BooleanControl soloControl = null;
    private BooleanControl muteControl;
    private GainControl gainControl;
    private LCRControl lcrControl;
    private FrontRearControl frontRearControl;
    private BusControls busControls;
    protected MixerControls mixerControls;
    private boolean isMaster;
    private int channelCount;

    public MixControls(MixerControls mixerControls, int stripId, BusControls busControls, boolean isMaster) {
        super(busControls.getId(), busControls.getName());
        EnumControl routeControl;
        this.mixerControls = mixerControls;
        this.busControls = busControls;
        this.isMaster = isMaster;
        int busId = busControls.getId();
        ChannelFormat format = this.getChannelFormat();
        this.channelCount = format.getCount();
        format.getLFE();
        if (this.channelCount >= 4) {
            this.frontRearControl = new FrontRearControl();
            this.add(this.frontRearControl);
        }
        if (format.getCenter() >= 0) {
            // empty if block
        }
        if (this.channelCount > 1) {
            if (stripId == 120) {
                PanControl pc = new PanControl();
                this.add(pc);
                this.lcrControl = pc;
            } else {
                BalanceControl bc = new BalanceControl();
                this.add(bc);
                this.lcrControl = bc;
            }
        }
        CompoundControl.ControlRow enables = new CompoundControl.ControlRow();
        if (isMaster) {
            enables.add(busControls.getSoloIndicator());
        } else {
            this.soloControl = this.createSoloControl();
            enables.add(this.soloControl);
            this.soloControl.addObserver(busControls);
        }
        this.muteControl = this.createMuteControl();
        enables.add(this.muteControl);
        this.add(enables);
        if (busId == 127 && (routeControl = this.createRouteControl(stripId)) != null) {
            this.add(routeControl);
        }
        float initialdB = (busId == 126 || busId == 125) && !isMaster ? -FaderLaw.ATTENUATION_CUTOFF : 0.0f;
        this.gainControl = new GainControl(initialdB);
        this.gainControl.setInsertColor(isMaster ? Color.BLUE.darker() : Color.black);
        this.add(this.gainControl);
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public ChannelFormat getChannelFormat() {
        return this.busControls.getChannelFormat();
    }

    public boolean isAlwaysVertical() {
        return true;
    }

    public boolean canBeDeleted() {
        return false;
    }

    public boolean hasPresets() {
        return false;
    }

    public boolean isSolo() {
        return this.soloControl == null ? this.hasSolo() : this.soloControl.getValue();
    }

    public boolean isMute() {
        return this.muteControl.getValue();
    }

    public boolean isEnabled() {
        return !this.isMute() && this.isSolo() == this.hasSolo();
    }

    public boolean hasSolo() {
        return this.busControls.hasSolo();
    }

    public float getGain() {
        return this.gainControl.getGain();
    }

    public void getChannelGains(float[] dest) {
        float g = this.getGain();
        switch (this.channelCount) {
            case 4: 
            case 6: {
                float r = g * this.frontRearControl.getRear();
                dest[3] = r * this.lcrControl.getRight();
                dest[2] = r * this.lcrControl.getLeft();
                float f = g * this.frontRearControl.getFront();
                dest[1] = f * this.lcrControl.getRight();
                dest[0] = f * this.lcrControl.getLeft();
                break;
            }
            case 2: {
                dest[1] = g * this.lcrControl.getRight();
                dest[0] = g * this.lcrControl.getLeft();
                break;
            }
            case 1: {
                dest[0] = 1.0f;
            }
        }
    }

    protected EnumControl createRouteControl(int stripId) {
        return null;
    }

    protected BooleanControl createMuteControl() {
        BooleanControl c = new BooleanControl(2, Localisation.getString("Mute"), false);
        c.setAnnotation(c.getName().substring(0, 1));
        c.setStateColor(true, Color.orange);
        return c;
    }

    protected BooleanControl createSoloControl() {
        BooleanControl c = new BooleanControl(3, Localisation.getString("Solo"), false);
        c.setAnnotation(c.getName().substring(0, 1));
        c.setStateColor(true, Color.green);
        return c;
    }

    public BooleanControl getMuteControl() {
        return this.muteControl;
    }

    public BooleanControl getSoloControl() {
        return this.soloControl;
    }

    public GainControl getGainControl() {
        return this.gainControl;
    }

    static /* synthetic */ float access$0() {
        return HALF_ROOT_TWO;
    }

    public static abstract class LCRControl
    extends FloatControl {
        protected static final LinearLaw linLaw = new LinearLaw(0.0f, 1.0f, "");
        private static final String[] presetNames = new String[]{Localisation.getString("Center"), Localisation.getString("Left"), Localisation.getString("Right")};

        public LCRControl(String name, ControlLaw law, float precision, float initialValue) {
            super(5, name, law, precision, initialValue);
            this.setInsertColor(Color.pink);
        }

        public abstract float getLeft();

        public abstract float getRight();

        public String[] getPresetNames() {
            return presetNames;
        }

        public void applyPreset(String presetName) {
            if (presetName.equals(Localisation.getString("Center"))) {
                this.setValue(0.5f);
            } else if (presetName.equals(Localisation.getString("Left"))) {
                this.setValue(0.0f);
            } else if (presetName.equals(Localisation.getString("Right"))) {
                this.setValue(1.0f);
            }
        }
    }

    public static class PanControl
    extends LCRControl {
        private float left = MixControls.access$0();
        private float right = MixControls.access$0();

        public PanControl() {
            super(Localisation.getString("Pan"), linLaw, 0.01f, 0.5f);
        }

        public float getLeft() {
            return this.left;
        }

        public float getRight() {
            return this.right;
        }

        public void setValue(float value) {
            super.setValue(value);
            this.left = (float)Math.cos(1.5707963267948966 * (double)value);
            this.right = (float)Math.sin(1.5707963267948966 * (double)value);
        }

        public float getPan() {
            return this.getValue();
        }
    }

    public static class BalanceControl
    extends LCRControl {
        private float left = 1.0f;
        private float right = 1.0f;

        public BalanceControl() {
            super(Localisation.getString("Balance"), linLaw, 0.01f, 0.5f);
        }

        public float getLeft() {
            return this.left;
        }

        public float getRight() {
            return this.right;
        }

        public void setValue(float value) {
            super.setValue(value);
            this.left = value < 0.5f ? 1.0f : 2.0f * (1.0f - value);
            this.right = value > 0.5f ? 1.0f : 2.0f * value;
        }

        public float getBalance() {
            return this.getValue();
        }
    }

    public static class FrontRearControl
    extends FloatControl {
        private float front = MixControls.access$0();
        private float rear = MixControls.access$0();
        protected static final LinearLaw linLaw = new LinearLaw(0.0f, 1.0f, "");
        private static final String[] presetNames = new String[]{Localisation.getString("Front"), Localisation.getString("Middle"), Localisation.getString("Rear")};

        public FrontRearControl() {
            super(6, Localisation.getString("F.S"), linLaw, 0.01f, 0.5f);
            this.setInsertColor(Color.GREEN.darker());
        }

        public float getFront() {
            return this.front;
        }

        public float getRear() {
            return this.rear;
        }

        public void setValue(float value) {
            super.setValue(value);
            this.front = (float)Math.cos(1.5707963267948966 * (double)value);
            this.rear = (float)Math.sin(1.5707963267948966 * (double)value);
        }

        public String[] getPresetNames() {
            return presetNames;
        }

        public void applyPreset(String presetName) {
            if (presetName.equals(Localisation.getString("Middle"))) {
                this.setValue(0.5f);
            } else if (presetName.equals(Localisation.getString("Front"))) {
                this.setValue(0.0f);
            } else if (presetName.equals(Localisation.getString("Rear"))) {
                this.setValue(1.0f);
            }
        }
    }

    public static class GainControl
    extends FaderControl {
        private float gain;

        public GainControl(float initialdB) {
            super(1, FaderLaw.BROADCAST, initialdB);
            this.gain = (float)Math.pow(10.0, (double)initialdB / 20.0);
            if (initialdB <= -FaderLaw.ATTENUATION_CUTOFF) {
                this.gain = 0.0f;
            }
        }

        public void setValue(float value) {
            super.setValue(value);
            this.gain = value <= -FaderLaw.ATTENUATION_CUTOFF ? 0.0f : (float)Math.pow(10.0, (double)value / 20.0);
        }

        public float getGain() {
            return this.gain;
        }
    }
}

