/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.AudioProcessChain;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.mixer.AudioMixer;
import uk.org.toot.audio.mixer.MainMixProcess;
import uk.org.toot.audio.mixer.MainMixVariables;
import uk.org.toot.audio.mixer.MixProcess;
import uk.org.toot.audio.mixer.MixVariables;

public class AudioMixerStrip
extends AudioProcessChain {
    protected AudioMixer mixer;
    private AudioBuffer buffer = null;
    private AudioBuffer.MetaInfo metaInfo;
    private AudioProcess input = null;
    private AudioProcess directOutput = null;
    private boolean isChannel = false;
    private ChannelFormat channelFormat;
    private int nmixed = 1;

    public AudioMixerStrip(AudioMixer mixer, AudioControlsChain controlsChain) {
        super(controlsChain);
        this.mixer = mixer;
        this.buffer = this.createBuffer();
        this.channelFormat = this.buffer.getChannelFormat();
    }

    public void setInputProcess(AudioProcess input) throws Exception {
        if (this.controlChain.getId() != 120) {
            throw new Exception("No external input to this Strip type");
        }
        this.input = input;
        input.open();
    }

    public void setDirectOutputProcess(AudioProcess output) throws Exception {
        this.directOutput = output;
    }

    public void silence() {
        if (this.nmixed > 0) {
            this.buffer.makeSilence();
            this.nmixed = 0;
        }
    }

    protected AudioBuffer createBuffer() {
        int id = this.controlChain.getId();
        if (id == 120) {
            this.isChannel = true;
            return this.mixer.getSharedBuffer();
        }
        if (id == 121) {
            AudioBuffer buf = this.mixer.createBuffer(this.getName());
            buf.setChannelFormat(this.mixer.getMainBus().getBuffer().getChannelFormat());
            return buf;
        }
        if (id == 123) {
            return this.mixer.getMainBus().getBuffer();
        }
        return this.mixer.getBus(this.getName()).getBuffer();
    }

    protected boolean processBuffer() {
        if (this.isChannel) {
            if (this.input == null) {
                return false;
            }
            int ret = this.input.processAudio(this.buffer);
            if (ret == 1) {
                return false;
            }
        }
        this.processAudio(this.buffer);
        if (this.directOutput != null) {
            this.directOutput.processAudio(this.buffer);
        }
        this.checkMetaInfo(this.buffer.getMetaInfo());
        return true;
    }

    protected void checkMetaInfo(AudioBuffer.MetaInfo info) {
        if (this.metaInfo == info) {
            return;
        }
        this.metaInfo = info;
        this.controlChain.setSourceLabel(this.metaInfo.getSourceLabel());
    }

    protected AudioProcess createProcess(AudioControls controls) {
        if (controls instanceof MixVariables) {
            MixVariables vars = (MixVariables)((Object)controls);
            if (vars.getName().equals(this.mixer.getMainBus().getName())) {
                AudioMixerStrip routedStrip = this.mixer.getMainStrip();
                return new MainMixProcess(routedStrip, (MainMixVariables)vars, this.mixer);
            }
            AudioMixerStrip routedStrip = this.mixer.getStripImpl(vars.getName());
            return new MixProcess(routedStrip, vars);
        }
        return super.createProcess(controls);
    }

    public int mix(AudioBuffer bufferToMix, float[] gain) {
        if (bufferToMix == null) {
            return 0;
        }
        int ret = this.channelFormat.mix(this.buffer, bufferToMix, gain);
        if (ret != 0) {
            ++this.nmixed;
        }
        return ret;
    }
}

