/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.meter.MeterProcess;
import uk.org.toot.audio.mixer.AudioMixer;
import uk.org.toot.audio.mixer.BusControls;

public class AudioMixerBus {
    private AudioBuffer buffer;
    private AudioProcess output = null;
    private AudioProcess meter = null;
    private boolean isFx = false;
    private String name;
    private ChannelFormat channelFormat;

    public AudioMixerBus(AudioMixer mixer, BusControls busControls) {
        this.name = busControls.getName();
        this.isFx = busControls.getId() == 125;
        this.channelFormat = busControls.getChannelFormat();
        this.buffer = mixer.createBuffer(this.name);
        this.buffer.setChannelFormat(this.channelFormat);
        this.setMeterProcess(new MeterProcess(busControls.getMeterControls()));
    }

    public void setOutputProcess(AudioProcess output) {
        this.output = output;
    }

    public void setMeterProcess(AudioProcess meter) {
        this.meter = meter;
    }

    public AudioBuffer getBuffer() {
        return this.buffer;
    }

    public String getName() {
        return this.name;
    }

    public void silence() {
        this.buffer.makeSilence();
    }

    public void write() {
        if (this.output == null && !this.isFx) {
            return;
        }
        if (this.output != null) {
            this.output.processAudio(this.buffer);
        }
        if (this.meter != null) {
            this.meter.processAudio(this.buffer);
        }
    }
}

