/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.meter;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.SimpleAudioProcess;
import uk.org.toot.audio.meter.MeterControls;

public class MeterProcess
extends SimpleAudioProcess {
    private MeterControls controls;
    private float bufferTime = -1.0f;

    public MeterProcess(MeterControls controls) {
        this.controls = controls;
    }

    public int processAudio(AudioBuffer buffer) {
        int nc = buffer.getChannelCount();
        int ns = buffer.getSampleCount();
        this.check(buffer);
        int c = 0;
        while (c < nc) {
            float[] array = buffer.getChannel(c);
            this.detectOvers(c, array, ns);
            this.detectPeak(c, array, ns);
            this.detectAverage(c, array, ns);
            ++c;
        }
        return 0;
    }

    private void check(AudioBuffer buffer) {
        float ms = (float)buffer.getSampleCount() / buffer.getSampleRate() * 1000.0f;
        if (this.bufferTime != ms) {
            this.bufferTime = ms;
            this.controls.setUpdateTime(ms);
        }
    }

    protected void detectOvers(int chan, float[] samples, int len) {
        int overs = 0;
        int i = 0;
        while (i < len) {
            float sample = samples[i];
            if (sample > 1.0f) {
                ++overs;
            } else if (sample < -1.0f) {
                ++overs;
            }
            ++i;
        }
        if (overs > 0) {
            this.controls.addOvers(chan, overs);
        }
    }

    protected void detectPeak(int chan, float[] samples, int len) {
        float peak = 0.0f;
        int i = 0;
        while (i < len) {
            float sample = samples[i];
            if (sample > peak) {
                peak = sample;
            } else if (-sample > peak) {
                peak = -sample;
            }
            ++i;
        }
        this.controls.setPeak(chan, peak);
    }

    protected void detectAverage(int chan, float[] samples, int len) {
        float sumOfSquares = 0.0f;
        int i = 0;
        while (i < len) {
            float sample = samples[i];
            sumOfSquares += sample * sample;
            ++i;
        }
        float rms = (float)(1.41 * Math.sqrt(sumOfSquares / (float)len));
        this.controls.setAverage(chan, rms);
    }
}

