/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.fader;

import uk.org.toot.audio.fader.FaderLaw;
import uk.org.toot.control.LawControl;

public class FaderControl
extends LawControl {
    private final String minLabel;
    private final String maxLabel;
    private final String unityLabel;
    private static final String[] presetNames = new String[]{"Unity"};

    public FaderControl(int id, FaderLaw law) {
        this(id, law, 0.0f, "-inf", "U", String.valueOf(law.getMaxdB()));
    }

    public FaderControl(int id, FaderLaw law, float initialValue, String minLabel, String unityLabel, String maxLabel) {
        super(id, "Level", law, 0.1f, initialValue);
        this.minLabel = minLabel == null ? "" : minLabel;
        this.unityLabel = unityLabel == null ? "" : unityLabel;
        this.maxLabel = maxLabel == null ? "" : maxLabel;
    }

    public FaderControl(int id, FaderLaw law, float initialValue) {
        this(id, law, initialValue, "", "", "");
    }

    public String[] getPresetNames() {
        return presetNames;
    }

    public void applyPreset(String name) {
        if (name.equals("Unity")) {
            this.setValue(0.0f);
        }
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public String getUnityLabel() {
        return this.unityLabel;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " with current value: " + this.getValue() + " " + this.getLaw().getUnits() + " (max: " + ((FaderLaw)this.getLaw()).getMaxdB() + ")";
    }
}

