/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import java.util.List;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.FloatDenormals;
import uk.org.toot.audio.dynamics.Compressor;
import uk.org.toot.audio.dynamics.CrossoverControl;
import uk.org.toot.audio.dynamics.CrossoverSection;
import uk.org.toot.audio.dynamics.DynamicsDesign;
import uk.org.toot.audio.filter.Crossover;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.IIRCrossover;
import uk.org.toot.control.Control;
import uk.org.toot.localisation.Localisation;

public class MultiBandCompressor
implements AudioProcess {
    private MultiBandControls multiBandControls;
    private Compressor[] compressors;
    private Crossover midXO;
    private Crossover hiXO;
    private Crossover loXO;
    private AudioBuffer[] bandBuffers;
    private int nbands;
    private int nchans = -1;
    private int nsamples = -1;
    private int sampleRate = -1;
    private boolean wasBypassed;

    public MultiBandCompressor(MultiBandControls c) {
        this.multiBandControls = c;
        this.wasBypassed = !c.isBypassed();
        List<Control> controls = c.getControls();
        this.nbands = (controls.size() + 1) / 2;
        if (this.nbands > 2) {
            this.nbands = 4;
            this.loXO = this.createCrossover((CrossoverControl)controls.get(2));
            this.midXO = this.createCrossover((CrossoverControl)controls.get(4));
            this.hiXO = this.createCrossover((CrossoverControl)controls.get(6));
        } else {
            this.midXO = this.createCrossover((CrossoverControl)controls.get(2));
            this.nbands = 2;
        }
        this.compressors = new Compressor[this.nbands];
        int i = 0;
        while (i < this.nbands) {
            this.compressors[i] = new Compressor(new DynamicsDesign((Compressor.Controls)controls.get(1 + i * 2)));
            ++i;
        }
    }

    public void open() {
    }

    public void close() {
    }

    public void clear() {
        this.midXO.clear();
        if (this.nbands > 2) {
            this.loXO.clear();
            this.hiXO.clear();
        }
        int b = 0;
        while (b < this.nbands) {
            this.compressors[b].clear();
            ++b;
        }
    }

    public int processAudio(AudioBuffer buffer) {
        boolean bypassed = this.multiBandControls.isBypassed();
        if (bypassed) {
            if (!this.wasBypassed) {
                this.clear();
                this.wasBypassed = true;
            }
            return 0;
        }
        this.conformBandBuffers(buffer);
        this.split(this.midXO, buffer, this.bandBuffers[0], this.bandBuffers[1]);
        if (this.nbands > 2) {
            this.split(this.hiXO, this.bandBuffers[1], this.bandBuffers[2], this.bandBuffers[3]);
            this.split(this.loXO, this.bandBuffers[0], this.bandBuffers[0], this.bandBuffers[1]);
        }
        int b = 0;
        while (b < this.nbands) {
            this.compressors[b].processAudio(this.bandBuffers[b]);
            ++b;
        }
        buffer.makeSilence();
        int nc = buffer.getChannelCount();
        int ns = buffer.getSampleCount();
        int c = 0;
        while (c < nc) {
            float[] samples = buffer.getChannel(c);
            int b2 = 0;
            while (b2 < this.nbands) {
                float[] bandsamples = this.bandBuffers[b2].getChannel(c);
                int i = 0;
                while (i < ns) {
                    float out = bandsamples[i];
                    if (!FloatDenormals.isDenormalOrZero(out)) {
                        int n = i;
                        samples[n] = samples[n] + ((b2 & 1) == 1 ? -out : out);
                    }
                    ++i;
                }
                ++b2;
            }
            ++c;
        }
        this.wasBypassed = bypassed;
        return 0;
    }

    protected void conformBandBuffers(AudioBuffer buf) {
        int nc = buf.getChannelCount();
        int ns = buf.getSampleCount();
        int sr = (int)buf.getSampleRate();
        if (this.bandBuffers == null) {
            this.bandBuffers = new AudioBuffer[this.nbands];
            int b = 0;
            while (b < this.nbands) {
                this.bandBuffers[b] = new AudioBuffer("MultiBandCompressor band " + (1 + b), nc, ns, sr);
                ++b;
            }
            this.updateSampleRate(sr);
        } else {
            if (this.nchans >= nc && this.nsamples == ns && this.sampleRate == sr) {
                return;
            }
            int b = 0;
            while (b < this.nbands) {
                AudioBuffer bbuf = this.bandBuffers[b];
                if (this.nchans < nc) {
                    int i = 0;
                    while (i < nc - this.nchans) {
                        bbuf.addChannel(true);
                        ++i;
                    }
                }
                if (this.nsamples != ns) {
                    bbuf.changeSampleCount(ns, false);
                }
                if (this.sampleRate != sr) {
                    bbuf.setSampleRate(sr);
                    this.updateSampleRate(sr);
                }
                ++b;
            }
        }
        this.nchans = nc;
        this.nsamples = ns;
        this.sampleRate = sr;
    }

    protected void split(Crossover xo, AudioBuffer source, AudioBuffer low, AudioBuffer high) {
        int c = 0;
        while (c < source.getChannelCount()) {
            xo.filter(source.getChannel(c), low.getChannel(c), high.getChannel(c), source.getSampleCount(), c);
            ++c;
        }
    }

    protected Crossover createCrossover(CrossoverControl c) {
        return new IIRCrossover(new CrossoverSection(c, Filter.Type.LPF), new CrossoverSection(c, Filter.Type.HPF));
    }

    protected void updateSampleRate(int rate) {
        this.midXO.setSampleRate(rate);
        if (this.nbands > 2) {
            this.loXO.setSampleRate(rate);
            this.hiXO.setSampleRate(rate);
        }
    }

    public static class MultiBandControls
    extends AudioControls {
        public MultiBandControls(String name) {
            super(38, name);
        }

        public boolean canBypass() {
            return true;
        }

        public boolean hasOrderedFrequencies() {
            return true;
        }
    }

    public static class DualBandControls
    extends MultiBandControls {
        public DualBandControls() {
            super(Localisation.getString("Dual.Band.Compressor"));
            this.add(new Compressor.Controls(Localisation.getString("Low"), 0));
            this.add(new CrossoverControl(Localisation.getString("Mid"), 1000.0f));
            this.add(new Compressor.Controls(Localisation.getString("High"), 30));
        }
    }

    public static class QuadBandControls
    extends MultiBandControls {
        public QuadBandControls() {
            super(Localisation.getString("Quad.Band.Compressor"));
            this.add(new Compressor.Controls(Localisation.getString("Low"), 0));
            this.add(new CrossoverControl(Localisation.getString("Low"), 250.0f));
            this.add(new Compressor.Controls(Localisation.getString("Lo.Mid"), 10));
            this.add(new CrossoverControl(Localisation.getString("Mid"), 1000.0f));
            this.add(new Compressor.Controls(Localisation.getString("Hi.Mid"), 20));
            this.add(new CrossoverControl(Localisation.getString("High"), 4000.0f));
            this.add(new Compressor.Controls(Localisation.getString("High"), 30));
        }
    }
}

