/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import java.util.Observable;
import java.util.Observer;
import org.tritonus.share.sampled.TVolumeUtils;
import uk.org.toot.audio.core.KVolumeUtils;
import uk.org.toot.audio.dynamics.DynamicsProcess;
import uk.org.toot.control.Control;
import uk.org.toot.misc.IObservable;

public class DynamicsDesign
implements DynamicsProcess.ProcessVariables {
    protected DesignVariables designVars;
    private float threshold;
    private float knee;
    private float attack;
    private float release;
    private float gain;
    private float depth;
    private int hold;
    private float sampleRate;
    private static float LOG_0_01 = (float)Math.log(0.01);

    public DynamicsDesign(DesignVariables vars) {
        this.designVars = vars;
        this.designVars.addObserver(new Observer(){

            public void update(Observable obs, Object obj) {
                Control c = (Control)obj;
                if (c.isIndicator()) {
                    return;
                }
                switch (c.getId() % 10) {
                    case 1: {
                        DynamicsDesign.this.deriveThreshold();
                        break;
                    }
                    case 3: {
                        DynamicsDesign.this.deriveKnee();
                        break;
                    }
                    case 4: {
                        DynamicsDesign.this.deriveAttack();
                        break;
                    }
                    case 5: {
                        DynamicsDesign.this.deriveHold();
                        break;
                    }
                    case 6: {
                        DynamicsDesign.this.deriveRelease();
                        break;
                    }
                    case 7: {
                        DynamicsDesign.this.deriveGain();
                        break;
                    }
                    case 9: {
                        DynamicsDesign.this.deriveDepth();
                    }
                }
            }
        });
        this.deriveSampleRateIndependentVariables();
    }

    protected void deriveSampleRateIndependentVariables() {
        this.deriveThreshold();
        this.deriveKnee();
        this.deriveGain();
        this.deriveDepth();
    }

    public void update(float sampleRate) {
        if (sampleRate != this.sampleRate) {
            this.sampleRate = sampleRate;
            this.deriveAttack();
            this.deriveHold();
            this.deriveRelease();
        }
    }

    protected void deriveThreshold() {
        this.threshold = (float)KVolumeUtils.log2lin(this.designVars.getThresholddB());
    }

    protected void deriveKnee() {
    }

    protected float deriveTimeFactor(float milliseconds) {
        float k = LOG_0_01 / milliseconds;
        return (float)Math.exp(k);
    }

    protected void deriveAttack() {
        this.attack = this.deriveTimeFactor(this.designVars.getAttackMilliseconds());
    }

    protected void deriveHold() {
        this.hold = (int)(this.designVars.getHoldMilliseconds() * this.sampleRate * 0.001f);
    }

    protected void deriveRelease() {
        this.release = this.deriveTimeFactor(this.designVars.getReleaseMilliseconds());
    }

    protected void deriveGain() {
        this.gain = (float)TVolumeUtils.log2lin(this.designVars.getGaindB());
    }

    protected void deriveDepth() {
        this.depth = (float)TVolumeUtils.log2lin(this.designVars.getDepthdB());
    }

    public boolean isBypassed() {
        return this.designVars.isBypassed();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public float getThresholddB() {
        return this.designVars.getThresholddB();
    }

    public float getRatio() {
        return this.designVars.getRatio();
    }

    public float getKnee() {
        return this.knee;
    }

    public float getAttack() {
        return this.attack;
    }

    public int getHold() {
        return this.hold;
    }

    public float getRelease() {
        return this.release;
    }

    public float getGain() {
        return this.gain;
    }

    public float getDepth() {
        return this.depth;
    }

    public void setDynamicGain(float dynamicGain) {
        this.designVars.setGainReduction((float)(20.0 * Math.log(dynamicGain)));
    }

    public static interface DesignVariables
    extends IObservable {
        public boolean isBypassed();

        public float getThresholddB();

        public float getRatio();

        public float getKneedB();

        public float getAttackMilliseconds();

        public float getHoldMilliseconds();

        public float getReleaseMilliseconds();

        public float getGaindB();

        public float getDepthdB();

        public void setGainReduction(float var1);
    }
}

