/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.dynamics;

import org.tritonus.share.sampled.TVolumeUtils;
import uk.org.toot.audio.core.KVolumeUtils;
import uk.org.toot.audio.dynamics.DynamicsControls;
import uk.org.toot.audio.dynamics.DynamicsProcess;
import uk.org.toot.localisation.Localisation;

public class Compressor
extends DynamicsProcess {
    public Compressor(DynamicsProcess.ProcessVariables vars) {
        super(vars, false);
    }

    protected float function(float value) {
        if (value > this.threshold) {
            float valdB = (float)KVolumeUtils.lin2log(value);
            float overdB = valdB - this.thresholddB;
            float gainReductiondB = -overdB * (this.ratio - 1.0f) / this.ratio;
            float gain = (float)TVolumeUtils.log2lin(gainReductiondB);
            return gain;
        }
        return 1.0f;
    }

    public static class Controls
    extends DynamicsControls {
        public Controls() {
            super(34, Localisation.getString("Compressor"));
        }

        public Controls(String name, int idOffset) {
            super(34, name, idOffset);
        }

        protected boolean hasGainReductionIndicator() {
            return true;
        }

        protected boolean hasRatio() {
            return true;
        }

        protected boolean hasGain() {
            return true;
        }
    }
}

