/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.delay.AbstractDelayControls;
import uk.org.toot.audio.delay.ModulatedDelayVariables;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.EnumControl;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LogLaw;
import uk.org.toot.localisation.Localisation;

public class ModulatedDelayControls
extends AbstractDelayControls
implements ModulatedDelayVariables {
    private static final ControlLaw delayLaw = new LogLaw(0.1f, 25.0f, "ms");
    private static final ControlLaw rateLaw = new LogLaw(0.02f, 2.0f, "Hz");
    private FloatControl delayControl;
    private BooleanControl tapeControl;
    private FloatControl rateControl;
    private ShapeControl shapeControl;
    private FloatControl depthControl;
    private BooleanControl linkControl;
    private static final int DELAY_ID = 1;
    private static final int TAPE_ID = 2;
    private static final int RATE_ID = 3;
    private static final int SHAPE_ID = 4;
    private static final int DEPTH_ID = 5;
    private static final int LINK_ID = 6;
    protected static final int PHASE_ID = 7;

    public ModulatedDelayControls() {
        this(20, Localisation.getString("Modulated.Delay"));
    }

    public ModulatedDelayControls(int id, String name) {
        super(id, name);
        this.add(this.createControlColumn1());
        this.shapeControl = new ShapeControl(4);
        this.rateControl = new FloatControl(3, Localisation.getString("Rate"), rateLaw, 0.01f, 0.2f);
        this.rateControl.setInsertColor(Color.magenta.darker());
        this.linkControl = new BooleanControl(6, Localisation.getString("Link"), false);
        this.linkControl.setStateColor(true, Color.LIGHT_GRAY);
        this.depthControl = new FloatControl(5, Localisation.getString("Depth"), UNITY_LIN_LAW, 0.01f, 0.5f);
        this.depthControl.setInsertColor(Color.lightGray);
        CompoundControl.ControlColumn g2 = new CompoundControl.ControlColumn();
        g2.add(this.shapeControl);
        g2.add(this.rateControl);
        g2.add(this.depthControl);
        this.add(g2);
        this.add(this.createCommonControlColumn(true));
    }

    protected CompoundControl.ControlColumn createControlColumn1() {
        this.tapeControl = new BooleanControl(2, Localisation.getString("Tape"), false);
        this.tapeControl.setStateColor(true, Color.pink);
        this.delayControl = new FloatControl(1, Localisation.getString("Delay"), delayLaw, 0.1f, 2.0f);
        this.delayControl.setInsertColor(Color.red.darker());
        CompoundControl.ControlColumn g1 = new CompoundControl.ControlColumn();
        g1.add(this.tapeControl);
        g1.add(this.delayControl);
        return g1;
    }

    public float getMaxDelayMilliseconds() {
        return 60.0f;
    }

    public float getDelayMilliseconds() {
        return this.delayControl.getValue();
    }

    public float getRate() {
        return this.isTape() ? this.rateControl.getValue() / 2.0f : this.rateControl.getValue();
    }

    public float getDepth() {
        return this.depthControl.getValue();
    }

    public float getFilterFrequency() {
        return 0.0f;
    }

    public boolean isTape() {
        return this.tapeControl.getValue();
    }

    public int getLFOShape() {
        return this.shapeControl.getIntValue();
    }

    public int getFilterType() {
        return 0;
    }

    public boolean canBypass() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShapeControl
    extends EnumControl {
        private static List<Object> values = new ArrayList<Object>();

        static {
            values.add("Sin");
            values.add("Tri");
        }

        public ShapeControl(int id) {
            super(id, "Shape", values.get(0));
        }

        @Override
        public List<Object> getValues() {
            return values;
        }
    }
}

