/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentLinkedQueue;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.AudioServices;
import uk.org.toot.control.CompoundControlChain;
import uk.org.toot.control.Control;

public class AudioProcessChain
implements AudioProcess {
    protected AudioControlsChain controlChain;
    protected List<AudioProcess> processes;
    private ConcurrentLinkedQueue<CompoundControlChain.ChainMutation> mutationQueue;
    private Observer controlChainObserver;
    private boolean debugTimes = false;
    private long[] t;
    private int debugIndex = 0;
    private long prevNanos = 0L;
    private long tstart;
    private long elapsed;

    public AudioProcessChain(AudioControlsChain controlChain) {
        this.controlChain = controlChain;
        this.controlChainObserver = new ControlChainObserver();
        this.mutationQueue = new ConcurrentLinkedQueue();
        this.processes = new ArrayList<AudioProcess>();
    }

    public void open() throws Exception {
        Control[] controlArray = this.controlChain.getMemberControls();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            Control control = controlArray[n];
            if (control instanceof AudioControls) {
                AudioProcess p = this.createProcess((AudioControls)control);
                this.processes.add(p);
                if (p != null) {
                    p.open();
                }
            }
            ++n;
        }
        this.controlChain.addObserver(this.controlChainObserver);
        if (this.debugTimes) {
            this.t = new long[20];
        }
    }

    public int processAudio(AudioBuffer buffer) {
        this.processMutations();
        if (this.debugTimes) {
            this.tstart = System.nanoTime();
            this.elapsed = this.tstart - this.prevNanos;
            this.prevNanos = this.tstart;
            ++this.debugIndex;
            this.debugIndex %= 100;
            if (this.debugIndex == 0) {
                return this.debugProcessAudio(buffer);
            }
        }
        int i = 0;
        while (i < this.processes.size()) {
            AudioProcess p = this.processes.get(i);
            try {
                if (p != null) {
                    p.processAudio(buffer);
                }
            }
            catch (Exception e) {
                try {
                    p.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.processes.set(i, null);
                System.out.println("DISABLED " + p + " in " + this.getName() + " due to:");
                e.printStackTrace();
            }
            ++i;
        }
        return 0;
    }

    public int debugProcessAudio(AudioBuffer buffer) {
        int len = this.processes.size();
        int i = 0;
        while (i < len) {
            this.processes.get(i).processAudio(buffer);
            this.t[i] = System.nanoTime();
            ++i;
        }
        int load = (int)(100L * (this.t[len - 1] - this.tstart) / this.elapsed);
        System.out.print(String.valueOf(load) + "%: ");
        long prevt = this.tstart;
        int i2 = 0;
        while (i2 < len) {
            System.out.print(String.valueOf(this.t[i2] - prevt) + ", ");
            prevt = this.t[i2];
            ++i2;
        }
        System.out.println();
        return 0;
    }

    public void close() {
        this.controlChain.deleteObserver(this.controlChainObserver);
        for (AudioProcess p : this.processes) {
            try {
                p.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.processes.clear();
        this.t = null;
    }

    public String getName() {
        return this.controlChain.getName();
    }

    public int getId() {
        return this.controlChain.getId();
    }

    protected AudioProcess createProcess(AudioControls controls) {
        return AudioServices.createProcess(controls);
    }

    protected void processMutations() {
        CompoundControlChain.ChainMutation m = this.mutationQueue.poll();
        if (m == null) {
            return;
        }
        try {
            switch (m.getType()) {
                case 1: {
                    AudioProcess p = this.processes.get(m.getIndex0());
                    p.close();
                    this.processes.remove(p);
                    break;
                }
                case 2: {
                    Control controls = this.controlChain.getControls().get(m.getIndex0());
                    if (controls instanceof AudioControls) {
                        AudioProcess p = this.createProcess((AudioControls)controls);
                        this.processes.add(m.getIndex0(), p);
                        if (p != null) {
                            p.open();
                        }
                    }
                    break;
                }
                case 3: {
                    AudioProcess process = this.processes.get(m.getIndex0());
                    this.processes.remove(m.getIndex0());
                    this.processes.add(m.getIndex1(), process);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception for " + this.controlChain.getName() + "Mutation: " + m);
            e.printStackTrace();
        }
    }

    protected class ControlChainObserver
    implements Observer {
        protected ControlChainObserver() {
        }

        public void update(Observable obs, Object obj) {
            if (obj instanceof CompoundControlChain.ChainMutation) {
                AudioProcessChain.this.mutationQueue.add((CompoundControlChain.ChainMutation)obj);
            }
        }
    }
}

