/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.core;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioServices;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.spi.AudioControlServiceDescriptor;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.CompoundControlChain;
import uk.org.toot.service.ServiceDescriptor;
import uk.org.toot.service.ServiceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioControlsChain
extends CompoundControlChain {
    private String sourceLabel;
    private ChannelFormat constraintChannelFormat = null;

    public AudioControlsChain(int id, String name) {
        super(id, name);
    }

    public AudioControlsChain(int id, int index, String name, ChannelFormat constraintFormat) {
        super(id, index, name);
        this.constraintChannelFormat = constraintFormat;
    }

    public void setSourceLabel(String label) {
        this.sourceLabel = label;
        this.setChanged();
        this.notifyObservers();
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public ChannelFormat getConstraintChannelFormat() {
        return this.constraintChannelFormat;
    }

    @Override
    protected CompoundControl createControl(String name) {
        return AudioServices.createControls(name);
    }

    @Override
    protected void checkInstanceIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " instance " + index + " < 0!");
        }
        if (index > 127) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " instance " + index + " > 127!");
        }
    }

    protected boolean isCompatibleDescriptor(ServiceDescriptor d) {
        if (this.constraintChannelFormat == null) {
            return true;
        }
        if (d instanceof AudioControlServiceDescriptor) {
            AudioControlServiceDescriptor acsd = (AudioControlServiceDescriptor)d;
            ChannelFormat descriptorFormat = acsd.getChannelFormat();
            if (descriptorFormat == null) {
                return true;
            }
            if (descriptorFormat.getCount() > this.constraintChannelFormat.getCount()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<ServiceDescriptor> descriptors() {
        final ArrayList<ServiceDescriptor> descriptors = new ArrayList<ServiceDescriptor>();
        AudioServices.accept(new ServiceVisitor(){

            public void visitDescriptor(ServiceDescriptor d) {
                if (AudioControlsChain.this.isCompatibleDescriptor(d)) {
                    descriptors.add(d);
                }
            }
        }, AudioControls.class);
        return descriptors;
    }
}

