/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.testing;

import java.util.Random;
import rasmus.interpreter.sampled.util.FFT;

public class MyFFTTest {
    int N = 3;
    FFT fft = new FFT(this.N);
    double fact = Math.PI * 2 / (double)this.N;

    void reco(double[] X, double[] x, int N) {
        int k = 0;
        while (k < N) {
            int j = 0;
            while (j < N) {
                x[2 * j] = x[2 * j] + (X[k * 2] * Math.cos((double)j * this.fact * (double)k) - X[k * 2 + 1] * Math.sin((double)j * this.fact * (double)k)) / (double)N;
                x[2 * j + 1] = x[2 * j + 1] + (X[k * 2] * Math.sin((double)j * this.fact * (double)k) + X[k * 2 + 1] * Math.cos((double)j * this.fact * (double)k)) / (double)N;
                ++j;
            }
            ++k;
        }
    }

    public void print(double[] x, int N) {
        int i = 0;
        while (i < N) {
            System.out.print(String.format("%+4.2f%+5.2fj ", x[2 * i], x[2 * i + 1]));
            if (i % ((N + 1) / 2) == 0) {
                System.out.print("|");
            }
            ++i;
        }
        System.out.println();
    }

    public void printReal(double[] x, int N) {
        int i = 0;
        while (i < N) {
            System.out.print(String.valueOf(String.format("(%4.2f %+5.2fj)", x[i], 0.0)) + " ");
            ++i;
        }
        System.out.println();
    }

    public void randFill(double[] x, int N) {
        Random rand = new Random();
        int i = 0;
        while (i < N) {
            x[i] = 2.0 * (rand.nextDouble() - 0.5);
            ++i;
        }
    }

    void copy(double[] a, double[] b, int N) {
        int i = 0;
        while (i < N) {
            b[i] = a[i];
            ++i;
        }
    }

    void scale(double[] a, double mult) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * mult;
        }
    }

    void toComplex(double[] xr, double[] x, int N) {
        int i = 0;
        while (i < N) {
            x[2 * i] = xr[i];
            x[2 * i + 1] = 0.0;
            ++i;
        }
    }

    void doitAll() {
        double[] xreal = new double[this.N];
        double[] xcomp = new double[2 * this.N];
        double[] temp = new double[2 * this.N];
        this.randFill(xreal, this.N);
        this.copy(xreal, temp, this.N);
        this.toComplex(xreal, xcomp, this.N);
        this.print(xcomp, this.N);
        this.fft.calc(xcomp, -1);
        this.print(xcomp, this.N);
        this.fft.calcReal(temp, -1);
        this.print(temp, this.N);
        double[] x2 = new double[]{temp[0] + temp[1], temp[0] - temp[1]};
        this.print(xcomp, 1);
    }

    public static void main(String[] args) {
        MyFFTTest t = new MyFFTTest();
        t.doitAll();
    }
}

