/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.interpreter.controls.sampled;

import java.util.ArrayList;
import java.util.Map;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.controls.ControlInstance;
import rasmus.interpreter.controls.ControlUnitFactory;
import rasmus.interpreter.metadata.MetaData;
import uk.co.drpj.interpreter.controls.sampled.CQFilterBankGraphInstance;

public class CQFilterBankGraph
extends ControlUnitFactory {
    public CQFilterBankGraph() {
        this.registerParameter(1, "timebase");
        this.registerParameter(2, "control");
        this.registerParameter(3, "samplerate");
        this.registerParameter(4, "channels");
    }

    public MetaData getMetaData() {
        MetaData metadata = super.getMetaData();
        metadata.setDescription("CQ Filter Bank");
        metadata.add(1, "timebase", "Timebase", "0.1", "sec", 1, 1);
        metadata.add(2, "control", "Control", null, null, 4, 1);
        metadata.add(3, "samplerate", "Sample rate", "44100", "Hz", 1, 1);
        metadata.add(4, "channels", "Channels", "1", null, 1, 1);
        metadata.add(-1, "chunksize", "filter chunk Size", "1024", null, 1, 1);
        metadata.add(-1, "Q", "Q", null, null, 1, 1);
        metadata.add(-1, "minHz", "min freq", null, "Hz", 1, 1);
        metadata.add(-1, "mindB", "min dB", null, "dB", 1, 1);
        metadata.add(-1, "maxdB", "max dB", null, "dB", 1, 1);
        metadata.add(-1, "binsperoctave", "bins per octave", "12", null, 1, 1);
        metadata.add(-1, "refreshrate", "Refresh rate", "15", "Hz", 1, 1);
        metadata.add(-1, "autostart", "Auto Start", null, null, 1, 1);
        ArrayList<String> options = new ArrayList<String>();
        options.add("0");
        options.add("1");
        options.add("2");
        metadata.add(-1, "mode", "Mode", "0", null, 1, 1).put("options", options);
        return metadata;
    }

    public ControlInstance newControlInstance(NameSpace namespace, Map parameters) {
        return new CQFilterBankGraphInstance(parameters);
    }
}

