/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.feature;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractAnalyzer;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;

class PJAudioOscilloscopeInstance
extends AudioAbstractAnalyzer {
    Variable input;
    Variable timebase;
    Variable samplerate;
    Variable channels;
    Variable refreshrate;

    public PJAudioOscilloscopeInstance(Map parameters) {
        super(parameters);
        this.timebase = (Variable)parameters.get("timebase");
        this.input = (Variable)parameters.get("input");
        this.samplerate = (Variable)parameters.get("samplerate");
        this.channels = (Variable)parameters.get("channels");
        this.refreshrate = (Variable)parameters.get("refreshrate");
        Dimension size = new Dimension(300, 300);
        this.getJComponent().setPreferredSize(size);
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.input == null) {
            return;
        }
        samplerate = 44100.0;
        refreshrate = 15.0;
        channels = 1;
        timebase = 0.01;
        if (this.samplerate != null) {
            samplerate = DoublePart.asDouble(this.samplerate);
        }
        if (this.channels != null) {
            channels = (int)DoublePart.asDouble(this.channels);
        }
        if (this.timebase != null) {
            timebase = (int)DoublePart.asDouble(this.timebase);
        }
        if (this.refreshrate != null) {
            refreshrate = (int)DoublePart.asDouble(this.refreshrate);
        }
        monitorsamples = (int)(samplerate * timebase);
        monitorsamplesc = monitorsamples * channels;
        audiosession = new AudioSession(samplerate, channels);
        audiostream = AudioEvents.openStream(this.input, audiosession);
        bufferlen = monitorsamplesc;
        if (bufferlen < 500) {
            bufferlen = 500 - 500 % channels;
        }
        buffer = new double[bufferlen];
        waittimens = (int)(1000.0 / refreshrate);
        lastms = System.currentTimeMillis();
        ** GOTO lbl67
        while ((len = audiostream.replace(buffer, 0, bufferlen)) != -1) {
            if (len != bufferlen) {
                Arrays.fill(buffer, len, bufferlen, 0.0);
            }
            while (System.currentTimeMillis() - lastms >= waittimens) {
                lastms = System.currentTimeMillis();
                g = this.getGraphics();
                size = this.getSize();
                w = size.width;
                h = size.height;
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, w, h);
                g.setColor(Color.GRAY);
                g.drawLine(0, h / 2, w, h / 2);
                g.drawLine(w / 2, 0, w / 2, h);
                c = 0;
                while (c < channels) {
                    lastx = 0;
                    lasty = h / 2;
                    x_step = (double)w / (double)monitorsamples;
                    x = 0.0;
                    if (c == 0) {
                        g.setColor(Color.RED);
                    } else if (c == 1) {
                        g.setColor(Color.BLUE);
                    } else {
                        g.setColor(Color.YELLOW);
                    }
                    i = c;
                    while (i < monitorsamplesc) {
                        sample = buffer[i];
                        i_x = (int)x;
                        y = (int)((sample * 0.5 + 0.5) * (double)h);
                        g.drawLine(lastx, lasty, i_x, y);
                        lasty = y;
                        lastx = i_x;
                        i += channels;
                        x += x_step;
                    }
                    ++c;
                }
                this.repaint();
lbl67:
                // 2 sources

                if (this.isActive()) continue;
            }
        }
        audiostream.close();
        audiosession.close();
    }
}

