/*
 * Decompiled with CFR 0.152.
 */
package uk.co.drpj.feature;

import uk.co.drpj.feature.Complex;

public class CQFilter {
    double[] freq;
    public double[] stateRe;
    public double[] stateIm;
    double[] dampRe;
    double[] dampIm;
    int nBins;
    double xLast = 0.0;

    public CQFilter(double freqMin, double binsPerOctave, int nBins, double Q, double Fs) {
        double smallVal = 0.5;
        this.nBins = nBins;
        this.freq = new double[nBins];
        this.stateRe = new double[nBins];
        this.stateIm = new double[nBins];
        this.dampRe = new double[nBins];
        this.dampIm = new double[nBins];
        int i = 0;
        while (i < nBins) {
            this.freq[i] = Math.PI * 2 * freqMin * Math.pow(2.0, (double)i / binsPerOctave);
            this.stateIm[i] = 0.0;
            this.stateRe[i] = 0.0;
            double nsamp = Q * Fs / this.freq[i];
            double damp = Math.pow(smallVal, 1.0 / nsamp);
            Complex dampC = Complex.expMinusJayArg(this.freq[i] / Fs);
            this.dampRe[i] = damp * dampC.re;
            this.dampIm[i] = damp * dampC.im;
            System.out.println(String.valueOf(this.freq[i]) + " " + damp + "  " + dampC.re + " " + dampC.im);
            ++i;
        }
    }

    public void feed(double[] x, int n) {
        int i = 0;
        while (i < n) {
            double dx = x[i] - this.xLast;
            this.xLast = x[i];
            int bin = 0;
            while (bin < this.nBins) {
                this.stateRe[bin] = this.stateRe[bin] * this.dampRe[bin] - this.stateIm[bin] * this.dampIm[bin] + dx;
                this.stateIm[bin] = this.stateIm[bin] * this.dampRe[bin] + this.stateRe[bin] * this.dampIm[bin];
                ++bin;
            }
            ++i;
        }
    }

    public void getMagnitude(double[] mag) {
        int i = 0;
        while (i < this.nBins) {
            mag[i] = Math.sqrt(this.stateRe[i] * this.stateRe[i] + this.stateIm[i] * this.stateIm[i]);
            ++i;
        }
    }
}

