/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff.sf2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import rasmus.util.ByteConversion;
import rasmus.util.riff.RiffReader;
import rasmus.util.riff.sf2.Info;
import rasmus.util.riff.sf2.InstrumentGenerator;
import rasmus.util.riff.sf2.InstrumentIndex;
import rasmus.util.riff.sf2.InstrumentModulator;
import rasmus.util.riff.sf2.InstrumentNamesAndIndices;
import rasmus.util.riff.sf2.PresetGenerator;
import rasmus.util.riff.sf2.PresetHeader;
import rasmus.util.riff.sf2.PresetIndex;
import rasmus.util.riff.sf2.PresetModulator;
import rasmus.util.riff.sf2.SampleHeader;
import rasmus.util.riff.sf2.SoundFontChunk;

public class SoundFont {
    long sampledata_size = 0L;
    long sampledata_offset = 0L;
    ArrayList presetheader_list = new ArrayList();
    ArrayList presetindex_list = new ArrayList();
    ArrayList presetmodulator_list = new ArrayList();
    ArrayList presetgenerator_list = new ArrayList();
    ArrayList instrumentnameandindices_list = new ArrayList();
    ArrayList instrumentindex_list = new ArrayList();
    ArrayList instrumentmodulator_list = new ArrayList();
    ArrayList instrumentgenerator_list = new ArrayList();
    ArrayList sampleheader_list = new ArrayList();
    Info info = new Info();

    public Info getInfo() {
        return this.info;
    }

    public ArrayList getPresetHeaderList() {
        return this.presetheader_list;
    }

    public ArrayList getPresetIndexList() {
        return this.presetindex_list;
    }

    public ArrayList getPresetModulatorList() {
        return this.presetmodulator_list;
    }

    public ArrayList getPresetGeneratorList() {
        return this.presetgenerator_list;
    }

    public ArrayList getInstrumentNamesAndIndicesList() {
        return this.instrumentnameandindices_list;
    }

    public ArrayList getInstrumentIndexList() {
        return this.instrumentindex_list;
    }

    public ArrayList getInsturmentModulatorList() {
        return this.instrumentmodulator_list;
    }

    public ArrayList getInstrumentGeneratorList() {
        return this.instrumentgenerator_list;
    }

    public ArrayList getSampleHeaderList() {
        return this.sampleheader_list;
    }

    public long getSampleDataSize() {
        return this.sampledata_size;
    }

    /*
     * Unable to fully structure code
     */
    public InputStream getSampleDataStream(InputStream inputstream) throws Exception {
        riffiterator = new RiffReader(inputstream);
        if (riffiterator.getFormat().equals("RIFF")) ** GOTO lbl11
        throw new Exception("Incorrect format");
lbl-1000:
        // 1 sources

        {
            subchunk = riffiterator.nextChunk();
            if (!subchunk.getFormat().equals("LIST") || !subchunk.getType().equals("sdta") || !subchunk.getFormat().equals("LIST")) continue;
            while (subchunk.hasNextChunk()) {
                subsubchunk = subchunk.nextChunk();
                format = subsubchunk.getFormat();
                if (!format.equals("smpl")) continue;
                return subsubchunk;
            }
lbl11:
            // 3 sources

            ** while (riffiterator.hasNextChunk())
        }
lbl12:
        // 1 sources

        return new ByteArrayInputStream(new byte[0]);
    }

    private byte[] arrayToBytes(ArrayList list) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        for (SoundFontChunk chunk : list) {
            bo.write(chunk.getBytes());
        }
        return bo.toByteArray();
    }

    private byte[] getPdtaBytes() throws IOException {
        byte[] phdr = this.arrayToBytes(this.presetheader_list);
        byte[] pbag = this.arrayToBytes(this.presetindex_list);
        byte[] pmod = this.arrayToBytes(this.presetmodulator_list);
        byte[] pgen = this.arrayToBytes(this.presetgenerator_list);
        byte[] inst = this.arrayToBytes(this.instrumentnameandindices_list);
        byte[] ibag = this.arrayToBytes(this.instrumentindex_list);
        byte[] imod = this.arrayToBytes(this.instrumentmodulator_list);
        byte[] igen = this.arrayToBytes(this.instrumentgenerator_list);
        byte[] shdr = this.arrayToBytes(this.sampleheader_list);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(ByteConversion.stringToChar("phdr", 4));
        bo.write(ByteConversion.longToDWord(phdr.length));
        bo.write(phdr);
        bo.write(ByteConversion.stringToChar("pbag", 4));
        bo.write(ByteConversion.longToDWord(pbag.length));
        bo.write(pbag);
        bo.write(ByteConversion.stringToChar("pmod", 4));
        bo.write(ByteConversion.longToDWord(pmod.length));
        bo.write(pmod);
        bo.write(ByteConversion.stringToChar("pgen", 4));
        bo.write(ByteConversion.longToDWord(pgen.length));
        bo.write(pgen);
        bo.write(ByteConversion.stringToChar("inst", 4));
        bo.write(ByteConversion.longToDWord(inst.length));
        bo.write(inst);
        bo.write(ByteConversion.stringToChar("ibag", 4));
        bo.write(ByteConversion.longToDWord(ibag.length));
        bo.write(ibag);
        bo.write(ByteConversion.stringToChar("imod", 4));
        bo.write(ByteConversion.longToDWord(imod.length));
        bo.write(imod);
        bo.write(ByteConversion.stringToChar("igen", 4));
        bo.write(ByteConversion.longToDWord(igen.length));
        bo.write(igen);
        bo.write(ByteConversion.stringToChar("shdr", 4));
        bo.write(ByteConversion.longToDWord(shdr.length));
        bo.write(shdr);
        return bo.toByteArray();
    }

    public void write(OutputStream outputstream, InputStream samplestream, long samplesize) throws IOException {
        byte[] info_bytes = this.getInfo().getBytes();
        byte[] pdta_bytes = this.getPdtaBytes();
        long sdta_size = 12L + samplesize;
        long size = (long)(24 + info_bytes.length + 12 + pdta_bytes.length + 12) + samplesize;
        outputstream.write(ByteConversion.stringToChar("RIFF", 4));
        outputstream.write(ByteConversion.longToDWord(size));
        outputstream.write(ByteConversion.stringToChar("sfbk", 4));
        outputstream.write(ByteConversion.stringToChar("LIST", 4));
        outputstream.write(ByteConversion.longToDWord(info_bytes.length + 4));
        outputstream.write(ByteConversion.stringToChar("INFO", 4));
        outputstream.write(info_bytes);
        outputstream.write(ByteConversion.stringToChar("LIST", 4));
        outputstream.write(ByteConversion.longToDWord(sdta_size));
        outputstream.write(ByteConversion.stringToChar("sdta", 4));
        outputstream.write(ByteConversion.stringToChar("smpl", 4));
        outputstream.write(ByteConversion.longToDWord(samplesize));
        byte[] buffer = new byte[4096];
        long sleft = samplesize;
        while (sleft != 0L) {
            if ((long)buffer.length > sleft) {
                buffer = new byte[(int)sleft];
            }
            samplestream.read(buffer);
            sleft -= (long)buffer.length;
            outputstream.write(buffer);
        }
        outputstream.write(ByteConversion.stringToChar("LIST", 4));
        outputstream.write(ByteConversion.longToDWord(pdta_bytes.length + 4));
        outputstream.write(ByteConversion.stringToChar("pdta", 4));
        outputstream.write(pdta_bytes);
    }

    /*
     * Unable to fully structure code
     */
    public void read(InputStream inputstream) throws Exception {
        isc = new InputStreamCounter(inputstream);
        riffiterator = new RiffReader(isc);
        if (riffiterator.getFormat().equals("RIFF")) ** GOTO lbl85
        throw new Exception("Incorrect format");
lbl-1000:
        // 1 sources

        {
            subchunk = riffiterator.nextChunk();
            if (!subchunk.getFormat().equals("LIST")) continue;
            if (subchunk.getType().equals("INFO") && subchunk.getFormat().equals("LIST")) {
                this.info.read(subchunk);
            }
            if (subchunk.getType().equals("sdta")) {
                while (subchunk.hasNextChunk()) {
                    subsubchunk = subchunk.nextChunk();
                    format = subsubchunk.getFormat();
                    if (!format.equals("smpl")) continue;
                    this.sampledata_size = subsubchunk.available();
                    this.sampledata_offset = isc.getPosition();
                }
            }
            if (!subchunk.getType().equals("pdta") || !subchunk.getFormat().equals("LIST")) continue;
            while (subchunk.hasNextChunk()) {
                subsubchunk = subchunk.nextChunk();
                format = subsubchunk.getFormat();
                if (format.equals("phdr")) {
                    while (subsubchunk.available() != 0) {
                        presetheader = new PresetHeader();
                        presetheader.read(subsubchunk);
                        this.presetheader_list.add(presetheader);
                    }
                }
                if (format.equals("pbag")) {
                    while (subsubchunk.available() != 0) {
                        presetindex = new PresetIndex();
                        presetindex.read(subsubchunk);
                        this.presetindex_list.add(presetindex);
                    }
                }
                if (format.equals("pmod")) {
                    while (subsubchunk.available() != 0) {
                        presetmodulator = new PresetModulator();
                        presetmodulator.read(subsubchunk);
                        this.presetmodulator_list.add(presetmodulator);
                    }
                }
                if (format.equals("pgen")) {
                    while (subsubchunk.available() != 0) {
                        presetgenerator = new PresetGenerator();
                        presetgenerator.read(subsubchunk);
                        this.presetgenerator_list.add(presetgenerator);
                    }
                }
                if (format.equals("inst")) {
                    while (subsubchunk.available() != 0) {
                        instrumentnameandindices = new InstrumentNamesAndIndices();
                        instrumentnameandindices.read(subsubchunk);
                        this.instrumentnameandindices_list.add(instrumentnameandindices);
                    }
                }
                if (format.equals("ibag")) {
                    while (subsubchunk.available() != 0) {
                        instrumentindex = new InstrumentIndex();
                        instrumentindex.read(subsubchunk);
                        this.instrumentindex_list.add(instrumentindex);
                    }
                }
                if (format.equals("imod")) {
                    while (subsubchunk.available() != 0) {
                        instrumentmodulator = new InstrumentModulator();
                        instrumentmodulator.read(subsubchunk);
                        this.instrumentmodulator_list.add(instrumentmodulator);
                    }
                }
                if (format.equals("igen")) {
                    while (subsubchunk.available() != 0) {
                        instrumentgenerator = new InstrumentGenerator();
                        instrumentgenerator.read(subsubchunk);
                        this.instrumentgenerator_list.add(instrumentgenerator);
                    }
                }
                if (!format.equals("shdr")) continue;
                while (subsubchunk.available() != 0) {
                    sampleheader = new SampleHeader();
                    sampleheader.read(subsubchunk);
                    this.sampleheader_list.add(sampleheader);
                }
            }
lbl85:
            // 4 sources

            ** while (riffiterator.hasNextChunk())
        }
lbl86:
        // 1 sources

    }

    private void setAttribute(Element element, String attrname, String value) {
        if (value != null) {
            element.setAttribute(attrname, value);
        }
    }

    public Document toDocument() throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element soundfont_element = doc.createElement("SoundFont");
        doc.appendChild(soundfont_element);
        this.setAttribute(soundfont_element, "version", String.valueOf(this.getInfo().major) + "." + this.getInfo().minor);
        this.setAttribute(soundfont_element, "bankname", this.getInfo().bankName);
        this.setAttribute(soundfont_element, "engineers", this.getInfo().engineers);
        this.setAttribute(soundfont_element, "creationdate", this.getInfo().creationDate);
        this.setAttribute(soundfont_element, "comments", this.getInfo().comments);
        this.setAttribute(soundfont_element, "product", this.getInfo().product);
        this.setAttribute(soundfont_element, "romname", this.getInfo().romName);
        if (this.getInfo().romName != null) {
            this.setAttribute(soundfont_element, "romversion", String.valueOf(this.getInfo().romVersionMajor) + "." + this.getInfo().romVersionMinor);
        }
        this.setAttribute(soundfont_element, "targetengine", this.getInfo().targetEngine);
        this.setAttribute(soundfont_element, "tools", this.getInfo().tools);
        this.setAttribute(soundfont_element, "sampledata_offset", "" + this.sampledata_offset);
        this.setAttribute(soundfont_element, "sampledata_length", "" + this.sampledata_size);
        ArrayList preset_list = this.getPresetHeaderList();
        ArrayList presetindex_list = this.getPresetIndexList();
        ArrayList presetgen_list = this.getPresetGeneratorList();
        int j = 0;
        while (j < preset_list.size()) {
            int nextoffset;
            PresetHeader preset = (PresetHeader)preset_list.get(j);
            Element preset_element = doc.createElement("preset");
            if (!preset.achPresetName.trim().equals("EOP")) {
                soundfont_element.appendChild(preset_element);
            }
            preset_element.setAttribute("id", "" + j);
            preset_element.setAttribute("name", preset.achPresetName.trim());
            preset_element.setAttribute("bank", "" + preset.wBank);
            preset_element.setAttribute("preset", "" + preset.wPreset);
            preset_element.setAttribute("library", "" + preset.dwLibrary);
            preset_element.setAttribute("genre", "" + preset.dwGenre);
            preset_element.setAttribute("morphology", "" + preset.dwMorphology);
            int offset = preset.wPresetBagNdx;
            if (j + 1 < preset_list.size()) {
                PresetHeader nextpreset = (PresetHeader)preset_list.get(j + 1);
                nextoffset = nextpreset.wPresetBagNdx;
            } else {
                nextoffset = presetindex_list.size();
            }
            int i = offset;
            while (i < nextoffset) {
                int b_nextoffset;
                PresetIndex presetindex = (PresetIndex)presetindex_list.get(i);
                int b_offset = presetindex.wGenNdx;
                if (i + 1 < presetindex_list.size()) {
                    PresetIndex b_presetindex = (PresetIndex)presetindex_list.get(i + 1);
                    b_nextoffset = b_presetindex.wGenNdx;
                } else {
                    b_nextoffset = presetgen_list.size();
                }
                Element generator_element = doc.createElement("generator");
                preset_element.appendChild(generator_element);
                int k = b_offset;
                while (k < b_nextoffset) {
                    PresetGenerator generator = (PresetGenerator)presetgen_list.get(k);
                    String value = generator.sfGenOper == 43 || generator.sfGenOper == 44 ? ByteConversion.byteToInt(generator.genAmount[0]) + " - " + ByteConversion.byteToInt(generator.genAmount[1]) : (generator.sfGenOper == 41 || generator.sfGenOper == 53 ? "" + ByteConversion.wordToInt_LE(generator.genAmount) : "" + ByteConversion.shortToInt(generator.genAmount));
                    generator_element.setAttribute(InstrumentGenerator.operators[generator.sfGenOper], value);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        ArrayList instrument_list = this.getInstrumentNamesAndIndicesList();
        ArrayList instrumentindex_list = this.getInstrumentIndexList();
        ArrayList instrumentgen_list = this.getInstrumentGeneratorList();
        int j2 = 0;
        while (j2 < instrument_list.size()) {
            int nextoffset;
            InstrumentNamesAndIndices ins = (InstrumentNamesAndIndices)instrument_list.get(j2);
            Element instrument = doc.createElement("instrument");
            if (!ins.achInstName.trim().equals("EOI")) {
                soundfont_element.appendChild(instrument);
            }
            instrument.setAttribute("id", "" + j2);
            instrument.setAttribute("name", ins.achInstName.trim());
            int offset = ins.wInstBagNdx;
            if (j2 + 1 < instrument_list.size()) {
                InstrumentNamesAndIndices nextins = (InstrumentNamesAndIndices)instrument_list.get(j2 + 1);
                nextoffset = nextins.wInstBagNdx;
            } else {
                nextoffset = instrumentindex_list.size();
            }
            int i = offset;
            while (i < nextoffset) {
                int b_nextoffset;
                InstrumentIndex insindex = (InstrumentIndex)instrumentindex_list.get(i);
                int b_offset = insindex.wGenNdx;
                if (i + 1 < instrumentindex_list.size()) {
                    InstrumentIndex b_insindex = (InstrumentIndex)instrumentindex_list.get(i + 1);
                    b_nextoffset = b_insindex.wGenNdx;
                } else {
                    b_nextoffset = instrumentgen_list.size();
                }
                Element generator_element = doc.createElement("generator");
                instrument.appendChild(generator_element);
                int k = b_offset;
                while (k < b_nextoffset) {
                    InstrumentGenerator generator = (InstrumentGenerator)instrumentgen_list.get(k);
                    String value = generator.sfGenOper == 43 || generator.sfGenOper == 44 ? ByteConversion.byteToInt(generator.genAmount[0]) + " - " + ByteConversion.byteToInt(generator.genAmount[1]) : (generator.sfGenOper == 41 || generator.sfGenOper == 53 ? "" + ByteConversion.wordToInt_LE(generator.genAmount) : "" + ByteConversion.shortToInt(generator.genAmount));
                    generator_element.setAttribute(InstrumentGenerator.operators[generator.sfGenOper], value);
                    ++k;
                }
                ++i;
            }
            ++j2;
        }
        ArrayList sample_list = this.getSampleHeaderList();
        int i = 0;
        while (i < sample_list.size()) {
            SampleHeader sampleheader = (SampleHeader)sample_list.get(i);
            Element sample = doc.createElement("sample");
            if (!sampleheader.achSampleName.trim().equals("EOS")) {
                soundfont_element.appendChild(sample);
            }
            sample.setAttribute("id", "" + i);
            sample.setAttribute("name", sampleheader.achSampleName.trim());
            sample.setAttribute("samplerate", "" + sampleheader.dwSampleRate);
            sample.setAttribute("start", "" + sampleheader.dwStart);
            sample.setAttribute("end", "" + sampleheader.dwEnd);
            sample.setAttribute("offset", "" + (sampleheader.dwStart * 2L + this.sampledata_offset));
            sample.setAttribute("datalength", "" + 2L * (sampleheader.dwEnd - sampleheader.dwStart));
            sample.setAttribute("length", "" + (sampleheader.dwEnd - sampleheader.dwStart));
            sample.setAttribute("loopstart", "" + sampleheader.dwStartloop);
            sample.setAttribute("loopend", "" + sampleheader.dwEndloop);
            sample.setAttribute("originalkey", "" + sampleheader.byOriginalKey);
            sample.setAttribute("pitchcorrection", "" + sampleheader.chPitchCorrection);
            sample.setAttribute("sampletype", "" + sampleheader.sfSampleType);
            sample.setAttribute("samplelink", "" + sampleheader.wSampleLink);
            ++i;
        }
        return doc;
    }

    public String toString() {
        SoundFont sf = this;
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("Version = " + sf.getInfo().major + "." + sf.getInfo().minor);
        stringbuffer.append("\nBank Name = " + sf.getInfo().bankName);
        stringbuffer.append("\nEngineers = " + sf.getInfo().engineers);
        stringbuffer.append("\nCreated = " + sf.getInfo().creationDate);
        stringbuffer.append("\nComments = " + sf.getInfo().comments);
        stringbuffer.append("\nCopyright = " + sf.getInfo().copyright);
        stringbuffer.append("\nProduct = " + sf.getInfo().product);
        stringbuffer.append("\nRom Name = " + sf.getInfo().romName);
        stringbuffer.append("\nRom Version = " + sf.getInfo().romVersionMajor + "." + sf.getInfo().romVersionMinor);
        stringbuffer.append("\nTarget Engine = " + sf.getInfo().targetEngine);
        stringbuffer.append("\nTarget Tools = " + sf.getInfo().tools);
        stringbuffer.append("\n\n");
        ArrayList preset_list = sf.getPresetHeaderList();
        ArrayList presetindex_list = sf.getPresetIndexList();
        ArrayList presetgen_list = sf.getPresetGeneratorList();
        int j = 0;
        while (j < preset_list.size()) {
            int nextoffset;
            PresetHeader preset = (PresetHeader)preset_list.get(j);
            stringbuffer.append("\n<Preset id = " + j + ">");
            stringbuffer.append("\n  Name = " + preset.achPresetName);
            stringbuffer.append("\n  Bank = " + preset.wBank);
            stringbuffer.append("\n  Preset = " + preset.wPreset);
            stringbuffer.append("\n  Library = " + preset.dwLibrary);
            stringbuffer.append("\n  Genre = " + preset.dwGenre);
            stringbuffer.append("\n  Morphology = " + preset.dwMorphology);
            int offset = preset.wPresetBagNdx;
            if (j + 1 < preset_list.size()) {
                PresetHeader nextpreset = (PresetHeader)preset_list.get(j + 1);
                nextoffset = nextpreset.wPresetBagNdx;
            } else {
                nextoffset = presetindex_list.size();
            }
            int i = offset;
            while (i < nextoffset) {
                int b_nextoffset;
                PresetIndex presetindex = (PresetIndex)presetindex_list.get(i);
                int b_offset = presetindex.wGenNdx;
                if (i + 1 < presetindex_list.size()) {
                    PresetIndex b_presetindex = (PresetIndex)presetindex_list.get(i + 1);
                    b_nextoffset = b_presetindex.wGenNdx;
                } else {
                    b_nextoffset = presetgen_list.size();
                }
                stringbuffer.append("\n  <Generator>");
                int k = b_offset;
                while (k < b_nextoffset) {
                    PresetGenerator generator = (PresetGenerator)presetgen_list.get(k);
                    String value = generator.sfGenOper == 43 || generator.sfGenOper == 44 ? ByteConversion.byteToInt(generator.genAmount[0]) + " - " + ByteConversion.byteToInt(generator.genAmount[1]) : (generator.sfGenOper == 41 || generator.sfGenOper == 53 ? "" + ByteConversion.wordToInt_LE(generator.genAmount) : "" + ByteConversion.shortToInt(generator.genAmount));
                    stringbuffer.append("\n     " + PresetGenerator.operators[generator.sfGenOper] + " = " + value);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        ArrayList instrument_list = sf.getInstrumentNamesAndIndicesList();
        ArrayList instrumentindex_list = sf.getInstrumentIndexList();
        ArrayList instrumentgen_list = sf.getInstrumentGeneratorList();
        int j2 = 0;
        while (j2 < instrument_list.size()) {
            int nextoffset;
            InstrumentNamesAndIndices ins = (InstrumentNamesAndIndices)instrument_list.get(j2);
            stringbuffer.append("\n<Instrument id = " + j2 + ">");
            stringbuffer.append("\n  Name = " + ins.achInstName);
            int offset = ins.wInstBagNdx;
            if (j2 + 1 < instrument_list.size()) {
                InstrumentNamesAndIndices nextins = (InstrumentNamesAndIndices)instrument_list.get(j2 + 1);
                nextoffset = nextins.wInstBagNdx;
            } else {
                nextoffset = instrumentindex_list.size();
            }
            int i = offset;
            while (i < nextoffset) {
                int b_nextoffset;
                InstrumentIndex insindex = (InstrumentIndex)instrumentindex_list.get(i);
                int b_offset = insindex.wGenNdx;
                if (i + 1 < instrumentindex_list.size()) {
                    InstrumentIndex b_insindex = (InstrumentIndex)instrumentindex_list.get(i + 1);
                    b_nextoffset = b_insindex.wGenNdx;
                } else {
                    b_nextoffset = instrumentgen_list.size();
                }
                stringbuffer.append("\n  <Generator>");
                int k = b_offset;
                while (k < b_nextoffset) {
                    InstrumentGenerator generator = (InstrumentGenerator)instrumentgen_list.get(k);
                    String value = generator.sfGenOper == 43 || generator.sfGenOper == 44 ? ByteConversion.byteToInt(generator.genAmount[0]) + " - " + ByteConversion.byteToInt(generator.genAmount[1]) : (generator.sfGenOper == 41 || generator.sfGenOper == 53 ? "" + ByteConversion.wordToInt_LE(generator.genAmount) : "" + ByteConversion.shortToInt(generator.genAmount));
                    stringbuffer.append("\n     " + InstrumentGenerator.operators[generator.sfGenOper] + " = " + value);
                    ++k;
                }
                ++i;
            }
            ++j2;
        }
        ArrayList sample_list = sf.getSampleHeaderList();
        int i = 0;
        while (i < sample_list.size()) {
            SampleHeader sampleheader = (SampleHeader)sample_list.get(i);
            stringbuffer.append("\n<Sample id = " + i + ">");
            stringbuffer.append("\n  Name = " + sampleheader.achSampleName);
            stringbuffer.append("\n  SampleRate = " + sampleheader.dwSampleRate);
            stringbuffer.append("\n  Start = " + sampleheader.dwStart);
            stringbuffer.append("\n  End = " + sampleheader.dwEnd);
            stringbuffer.append("\n  Length = " + (sampleheader.dwEnd - sampleheader.dwStart));
            stringbuffer.append("\n  Loop Start = " + sampleheader.dwStartloop);
            stringbuffer.append("\n  Loop End = " + sampleheader.dwEndloop);
            stringbuffer.append("\n  Original Key = " + sampleheader.byOriginalKey);
            stringbuffer.append("\n  Pitch Correction = " + sampleheader.chPitchCorrection);
            stringbuffer.append("\n  Sample Type = " + sampleheader.sfSampleType);
            stringbuffer.append("\n  Sample Link = " + sampleheader.wSampleLink);
            ++i;
        }
        stringbuffer.append("\n<SampleData offset=" + this.sampledata_offset + " length=" + this.sampledata_size + ">");
        return stringbuffer.toString();
    }

    class InputStreamCounter
    extends InputStream {
        InputStream inputstream;
        long pos = 0L;

        public long getPosition() {
            return this.pos;
        }

        public InputStreamCounter(InputStream inputstream) {
            this.inputstream = inputstream;
        }

        public int read() throws IOException {
            int len = this.inputstream.read();
            if (len != -1) {
                ++this.pos;
            }
            return len;
        }

        public int available() throws IOException {
            return this.inputstream.available();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int readed = this.inputstream.read(b, off, len);
            if (readed > 0) {
                this.pos += (long)readed;
            }
            return readed;
        }

        public int read(byte[] b) throws IOException {
            int readed = this.inputstream.read(b);
            if (readed > 0) {
                this.pos += (long)readed;
            }
            return readed;
        }

        public long skip(long n) throws IOException {
            long readed = this.inputstream.skip(n);
            if (readed > 0L) {
                this.pos += readed;
            }
            return readed;
        }
    }
}

