/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff.sf2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import rasmus.util.ByteConversion;
import rasmus.util.riff.sf2.SoundFontChunk;

public class SampleHeader
extends SoundFontChunk {
    public String achSampleName;
    public long dwStart;
    public long dwEnd;
    public long dwStartloop;
    public long dwEndloop;
    public long dwSampleRate;
    public int byOriginalKey;
    public int chPitchCorrection;
    public int wSampleLink;
    public int sfSampleType;

    public void read(InputStream stream) throws IOException {
        byte[] string_buffer = new byte[20];
        byte[] byte_buffer = new byte[1];
        byte[] word_buffer = new byte[2];
        byte[] dword_buffer = new byte[4];
        stream.read(string_buffer);
        this.achSampleName = ByteConversion.charToString(string_buffer);
        stream.read(dword_buffer);
        this.dwStart = ByteConversion.dwordToLong(dword_buffer);
        stream.read(dword_buffer);
        this.dwEnd = ByteConversion.dwordToLong(dword_buffer);
        stream.read(dword_buffer);
        this.dwStartloop = (int)ByteConversion.dwordToLong(dword_buffer);
        stream.read(dword_buffer);
        this.dwEndloop = (int)ByteConversion.dwordToLong(dword_buffer);
        stream.read(dword_buffer);
        this.dwSampleRate = ByteConversion.dwordToLong(dword_buffer);
        stream.read(byte_buffer);
        this.byOriginalKey = ByteConversion.byteToInt(byte_buffer);
        stream.read(byte_buffer);
        int ch = ByteConversion.byteToInt(byte_buffer);
        this.chPitchCorrection = ch >= 128 ? ch - 256 : ch;
        stream.read(word_buffer);
        this.wSampleLink = ByteConversion.wordToInt_LE(word_buffer);
        stream.read(word_buffer);
        this.sfSampleType = ByteConversion.wordToInt_LE(word_buffer);
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(ByteConversion.stringToChar(this.achSampleName, 20));
        bo.write(ByteConversion.longToDWord(this.dwStart));
        bo.write(ByteConversion.longToDWord(this.dwEnd));
        bo.write(ByteConversion.longToDWord(this.dwStartloop));
        bo.write(ByteConversion.longToDWord(this.dwEndloop));
        bo.write(ByteConversion.longToDWord(this.dwSampleRate));
        bo.write(ByteConversion.intToByte(this.byOriginalKey));
        bo.write(ByteConversion.intToByte((this.chPitchCorrection + 256) % 256));
        bo.write(ByteConversion.intToWord(this.wSampleLink));
        bo.write(ByteConversion.intToWord(this.sfSampleType));
        return bo.toByteArray();
    }
}

