/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff.sf2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import rasmus.util.ByteConversion;
import rasmus.util.riff.sf2.SoundFontChunk;

public class PresetHeader
extends SoundFontChunk {
    public String achPresetName;
    public int wPreset;
    public int wBank;
    public int wPresetBagNdx;
    public long dwLibrary;
    public long dwGenre;
    public long dwMorphology;

    public void read(InputStream stream) throws IOException {
        byte[] string_buffer = new byte[20];
        byte[] word_buffer = new byte[2];
        byte[] dword_buffer = new byte[4];
        stream.read(string_buffer);
        this.achPresetName = ByteConversion.charToString(string_buffer);
        stream.read(word_buffer);
        this.wPreset = ByteConversion.wordToInt_LE(word_buffer);
        stream.read(word_buffer);
        this.wBank = ByteConversion.wordToInt_LE(word_buffer);
        stream.read(word_buffer);
        this.wPresetBagNdx = ByteConversion.wordToInt_LE(word_buffer);
        stream.read(dword_buffer);
        this.dwLibrary = ByteConversion.dwordToLong(dword_buffer);
        stream.read(dword_buffer);
        this.dwGenre = ByteConversion.dwordToLong(dword_buffer);
        stream.read(dword_buffer);
        this.dwMorphology = ByteConversion.dwordToLong(dword_buffer);
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(ByteConversion.stringToChar(this.achPresetName, 20));
        bo.write(ByteConversion.intToWord(this.wPreset));
        bo.write(ByteConversion.intToWord(this.wBank));
        bo.write(ByteConversion.intToWord(this.wPresetBagNdx));
        bo.write(ByteConversion.longToDWord(this.dwLibrary));
        bo.write(ByteConversion.longToDWord(this.dwGenre));
        bo.write(ByteConversion.longToDWord(this.dwMorphology));
        return bo.toByteArray();
    }
}

