/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util.riff.sf2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import rasmus.util.ByteConversion;
import rasmus.util.riff.RiffReader;
import rasmus.util.riff.sf2.SoundFontChunk;

public class Info
extends SoundFontChunk {
    public int major = 2;
    public int minor = 1;
    public String targetEngine = "E-mu 10K1";
    public String bankName = "untitled";
    public String romName = null;
    public int romVersionMajor = -1;
    public int romVersionMinor = -1;
    public String creationDate = null;
    public String engineers = null;
    public String product = null;
    public String copyright = null;
    public String comments = null;
    public String tools = null;

    public void read(RiffReader subchunk) throws UnsupportedEncodingException, IOException {
        while (subchunk.hasNextChunk()) {
            byte[] buffer;
            byte[] bword;
            RiffReader subsubchunk = subchunk.nextChunk();
            String format = subsubchunk.getFormat();
            if (format.equals("ifil")) {
                bword = new byte[2];
                subsubchunk.read(bword);
                this.major = ByteConversion.wordToInt_LE(bword);
                subsubchunk.read(bword);
                this.minor = ByteConversion.wordToInt_LE(bword);
            }
            if (format.equals("isng")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.targetEngine = ByteConversion.charToString(buffer);
            }
            if (format.equals("INAM")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.bankName = ByteConversion.charToString(buffer);
            }
            if (format.equals("irom")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.romName = ByteConversion.charToString(buffer);
            }
            if (format.equals("iver")) {
                bword = new byte[2];
                subsubchunk.read(bword);
                this.romVersionMajor = ByteConversion.wordToInt_LE(bword);
                subsubchunk.read(bword);
                this.romVersionMinor = ByteConversion.wordToInt_LE(bword);
            }
            if (format.equals("ICRD")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.creationDate = ByteConversion.charToString(buffer);
            }
            if (format.equals("IENG")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.engineers = ByteConversion.charToString(buffer);
            }
            if (format.equals("IPRD")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.product = ByteConversion.charToString(buffer);
            }
            if (format.equals("ICOP")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.copyright = ByteConversion.charToString(buffer);
            }
            if (format.equals("ICMT")) {
                buffer = new byte[subsubchunk.available()];
                subsubchunk.read(buffer);
                this.comments = ByteConversion.charToString(buffer);
            }
            if (!format.equals("ISFT")) continue;
            buffer = new byte[subsubchunk.available()];
            subsubchunk.read(buffer);
            this.tools = ByteConversion.charToString(buffer);
        }
    }

    public byte[] getBytes() throws IOException {
        byte[] buffer;
        byte[] major_bytes = ByteConversion.intToWord(this.major);
        byte[] minor_bytes = ByteConversion.intToWord(this.minor);
        byte[] targetEngine_bytes = this.targetEngine.getBytes("Latin1");
        byte[] bankName_bytes = this.bankName.getBytes("Latin1");
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(ByteConversion.stringToChar("ifil", 4));
        bo.write(ByteConversion.longToDWord(major_bytes.length + minor_bytes.length));
        bo.write(major_bytes);
        bo.write(minor_bytes);
        bo.write(ByteConversion.stringToChar("INAM", 4));
        bo.write(ByteConversion.longToDWord(bankName_bytes.length + 2));
        bo.write(bankName_bytes);
        bo.write(0);
        bo.write(0);
        bo.write(ByteConversion.stringToChar("isng", 4));
        bo.write(ByteConversion.longToDWord(targetEngine_bytes.length + 1));
        bo.write(targetEngine_bytes);
        bo.write(0);
        if (this.romName != null) {
            buffer = this.romName.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("irom", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 2));
            bo.write(buffer);
            bo.write(0);
            bo.write(0);
        }
        if (this.creationDate != null) {
            buffer = this.creationDate.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("ICRD", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 2));
            bo.write(buffer);
            bo.write(0);
            bo.write(0);
        }
        if (this.engineers != null) {
            buffer = this.engineers.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("IENG", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 2));
            bo.write(buffer);
            bo.write(0);
            bo.write(0);
        }
        if (this.product != null) {
            buffer = this.product.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("IPRD", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 1));
            bo.write(buffer);
            bo.write(0);
        }
        if (this.copyright != null) {
            buffer = this.copyright.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("ICOP", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 2));
            bo.write(buffer);
            bo.write(0);
            bo.write(0);
        }
        if (this.comments != null) {
            buffer = this.comments.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("ICMT", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 1));
            bo.write(buffer);
            bo.write(0);
        }
        if (this.tools != null) {
            buffer = this.tools.getBytes("latin1");
            bo.write(ByteConversion.stringToChar("ISFT", 4));
            bo.write(ByteConversion.longToDWord(buffer.length + 2));
            bo.write(buffer);
            bo.write(0);
            bo.write(0);
        }
        return bo.toByteArray();
    }
}

