/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

class ThreadQueueWorker
extends Thread {
    public static ThreadQueueWorker sharedworker = null;
    ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue(300);
    boolean active = true;

    ThreadQueueWorker() {
    }

    public static ThreadQueueWorker getInstance() {
        if (sharedworker == null) {
            ThreadQueueWorker sharedworker = new ThreadQueueWorker();
            sharedworker.setDaemon(true);
            sharedworker.start();
            sharedworker.setPriority(10);
            ThreadQueueWorker.sharedworker = sharedworker;
        }
        return sharedworker;
    }

    public void run() {
        try {
            while (this.active) {
                Runnable item = this.queue.poll(50L, TimeUnit.SECONDS);
                if (item == null) continue;
                item.run();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopThreadQueue() throws InterruptedException {
        this.queue.offer(new Runnable(){

            public void run() {
                ThreadQueueWorker.this.active = false;
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void invokeLater(Runnable runnable) {
        if (!this.queue.offer(runnable)) {
            try {
                this.queue.offer(runnable, 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

