/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util;

import java.io.UnsupportedEncodingException;

public final class ByteConversion {
    public static final String guidToString(byte[] buffer) {
        String str = "";
        int i = 0;
        while (i < buffer.length) {
            String hex = Integer.toHexString(ByteConversion.byteToInt(buffer[i]));
            str = hex.length() == 1 ? String.valueOf(str) + "0" + hex : String.valueOf(str) + hex;
            ++i;
        }
        return str;
    }

    public static final int byteToInt(byte buffer) {
        return (256 + buffer) % 256;
    }

    public static final int byteToInt(byte[] buffer) {
        return ByteConversion.byteToInt(buffer[0]);
    }

    public static final String charToString(byte[] buffer) throws UnsupportedEncodingException {
        String string = new String(buffer, "latin1");
        int li = string.indexOf(0);
        if (li != -1) {
            string = string.substring(0, li);
        }
        return string;
    }

    public static final long dwordToLong(byte[] buffer) {
        return ((256L + (long)buffer[3]) % 256L << 24) + ((256L + (long)buffer[2]) % 256L << 16) + ((256L + (long)buffer[1]) % 256L << 8) + (256L + (long)buffer[0]) % 256L;
    }

    public static final byte[] intToByte(int buffer) {
        byte[] data = new byte[]{(byte)buffer};
        return data;
    }

    public static final byte[] intToShort(int buffer) {
        if (buffer < 0) {
            buffer += 65536;
        }
        return ByteConversion.intToWord(buffer);
    }

    public static final byte[] intToWord(int buffer) {
        byte[] data = new byte[]{(byte)(buffer % 256), (byte)((buffer /= 256) % 256)};
        buffer /= 256;
        return data;
    }

    public static final byte[] longToDWord(long buffer) {
        byte[] data = new byte[]{(byte)(buffer % 256L), (byte)((buffer /= 256L) % 256L), (byte)((buffer /= 256L) % 256L), (byte)((buffer /= 256L) % 256L)};
        buffer /= 256L;
        return data;
    }

    public static final int shortToInt(byte[] buffer) {
        int result = ((256 + buffer[1]) % 256 << 8) + (256 + buffer[0]) % 256;
        if (result >= 32512) {
            return result - 65536;
        }
        return result;
    }

    public static final byte[] stringToChar(String buffer, int size) {
        byte[] data = buffer.getBytes();
        byte[] outbuffer = new byte[size];
        int i = 0;
        while (i < data.length) {
            outbuffer[i] = data[i];
            ++i;
        }
        i = data.length;
        while (i < outbuffer.length) {
            outbuffer[i] = 0;
            ++i;
        }
        return outbuffer;
    }

    public static final int wordToInt_LE(byte[] buffer) {
        return ((256 + buffer[1]) % 256 << 8) + (256 + buffer[0]) % 256;
    }

    public static final int wordToInt_BE(byte[] buffer) {
        return ((256 + buffer[0]) % 256 << 8) + (256 + buffer[1]) % 256;
    }
}

