/*
 * Decompiled with CFR 0.152.
 */
package rasmus.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ABCTokenizer {
    private ArrayList tokens;
    int[] keysig = new int[7];
    String notekeys;
    private String legalSymbols;
    private int channel;
    private int octave;
    private int velocity;
    private double notelen;
    private double beatpos;
    private boolean isgrouping;
    private double groupmul;
    private String meter;

    public ABCTokenizer() {
        Arrays.fill(this.keysig, 0);
        this.notekeys = "fcgdaeb";
        this.legalSymbols = "zxabcdefgABCDEFG";
        this.channel = 1;
        this.octave = 4;
        this.velocity = 127;
        this.notelen = 0.125;
        this.beatpos = 0.0;
        this.isgrouping = false;
        this.groupmul = 1.0;
        this.meter = "4/4";
    }

    public void addLegalSymbols(String symbols) {
        this.legalSymbols = String.valueOf(this.legalSymbols) + symbols;
    }

    public List parse(String code) {
        char[] charcode = code.toCharArray();
        this.tokens = new ArrayList();
        this.parse(charcode, 0, charcode.length);
        return this.tokens;
    }

    private void parse(char[] code, int start, int end) {
        int lasti = 0;
        int i = start;
        while (i < end) {
            char c = code[i];
            if (c == '\n' || c == '\r') {
                if (i - lasti > 0) {
                    this.parseLine(code, lasti, i);
                }
                lasti = i + 1;
            }
            ++i;
        }
        if (end - lasti > 0) {
            this.parseLine(code, lasti, end);
        }
    }

    private void parseLine(char[] code, int start, int end) {
        int i = start;
        while (i < end) {
            char c = code[i];
            if (c == '[') break;
            if (c == ':') {
                char c_pre = ' ';
                int c_post = 32;
                if (i - 1 >= 0) {
                    c_pre = code[i - 1];
                }
                if (i + 1 < end) {
                    c_post = code[i + 1];
                }
                if (!Character.isLetter(c_pre) || c_post == 58 || c_post == 124) break;
                this.parseCommandLine(code, start, end);
                return;
            }
            ++i;
        }
        this.parseNotationLine(code, start, end);
    }

    private void parseCommandLine(char[] code, int start, int end) {
        int i = start;
        while (i < end) {
            char c = code[i];
            if (c == ':') {
                String fieldname = new String(code, start, i - start);
                String fieldvalue = new String(code, i + 1, end - (i + 1));
                CommandToken ctoken = new CommandToken();
                ctoken.channel = this.channel;
                ctoken.pos = this.beatpos * 4.0;
                ctoken.fieldname = fieldname;
                ctoken.fieldvalue = fieldvalue;
                ctoken.code = String.valueOf(fieldname) + ":" + fieldvalue;
                this.tokens.add(ctoken);
                if (fieldname.equals("v")) {
                    this.velocity = Integer.parseInt(fieldvalue.trim());
                } else if (fieldname.equals("c")) {
                    this.channel = Integer.parseInt(fieldvalue.trim());
                } else if (fieldname.equals("o")) {
                    this.octave = Integer.parseInt(fieldvalue.trim());
                } else if (fieldname.equals("L")) {
                    this.notelen = ABCTokenizer.parseNoteLen(fieldvalue.trim());
                } else if (fieldname.equals("M")) {
                    this.meter = fieldvalue.trim();
                } else if (fieldname.equals("K")) {
                    StringTokenizer st = new StringTokenizer(fieldvalue.trim(), " ");
                    boolean firsttoken = true;
                    int key = 0;
                    int keytype = 0;
                    boolean keytypeset = false;
                    boolean hasprocessedkey = false;
                    while (st.hasMoreTokens()) {
                        int li;
                        String token = st.nextToken().trim();
                        String ltoken = token.toLowerCase();
                        if (ltoken.startsWith("clef=")) break;
                        if (firsttoken) {
                            firsttoken = false;
                            if (ltoken.length() != 0) {
                                key = this.notekeys.indexOf(ltoken.charAt(0)) - 1;
                                if (key != -2) {
                                    if ((ltoken = ltoken.substring(1)).length() != 0) {
                                        char cc = ltoken.charAt(0);
                                        if (cc == 'b') {
                                            key -= 7;
                                            ltoken = ltoken.substring(1);
                                        } else if (cc == '#') {
                                            key += 7;
                                            ltoken = ltoken.substring(1);
                                        }
                                    }
                                } else {
                                    key = 0;
                                }
                            }
                        }
                        if (!keytypeset) {
                            if (ltoken.startsWith("none") || ltoken.startsWith("exp")) {
                                keytype = 0;
                                key = 0;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("lyd")) {
                                keytype = -1;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("maj") || ltoken.startsWith("ion")) {
                                keytype = 0;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("mix")) {
                                keytype = 1;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("dor")) {
                                keytype = 2;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("min") || ltoken.startsWith("aeo")) {
                                keytype = 3;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("phr")) {
                                keytype = 4;
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("loc")) {
                                keytype = 5;
                                keytypeset = true;
                            }
                            if (keytypeset) {
                                key -= keytype;
                            }
                        }
                        if (!hasprocessedkey) {
                            if (ltoken.startsWith("=")) {
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("^")) {
                                keytypeset = true;
                            }
                            if (ltoken.startsWith("_")) {
                                keytypeset = true;
                            }
                            if (!st.hasMoreTokens()) {
                                keytypeset = true;
                            }
                            if (keytypeset) {
                                hasprocessedkey = true;
                                if (key < -7) {
                                    key += 12;
                                }
                                if (key > 7) {
                                    key -= 12;
                                }
                                Arrays.fill(this.keysig, 0);
                                if (key > 0) {
                                    this.keysig[0] = this.keysig[0] + 1;
                                }
                                if (key > 1) {
                                    this.keysig[1] = this.keysig[1] + 1;
                                }
                                if (key > 2) {
                                    this.keysig[2] = this.keysig[2] + 1;
                                }
                                if (key > 3) {
                                    this.keysig[3] = this.keysig[3] + 1;
                                }
                                if (key > 4) {
                                    this.keysig[4] = this.keysig[4] + 1;
                                }
                                if (key > 5) {
                                    this.keysig[5] = this.keysig[5] + 1;
                                }
                                if (key > 6) {
                                    this.keysig[6] = this.keysig[6] + 1;
                                }
                                if (key < 0) {
                                    this.keysig[6] = this.keysig[6] - 1;
                                }
                                if (key < -1) {
                                    this.keysig[5] = this.keysig[5] - 1;
                                }
                                if (key < -2) {
                                    this.keysig[4] = this.keysig[4] - 1;
                                }
                                if (key < -3) {
                                    this.keysig[3] = this.keysig[3] - 1;
                                }
                                if (key < -4) {
                                    this.keysig[2] = this.keysig[2] - 1;
                                }
                                if (key < -5) {
                                    this.keysig[1] = this.keysig[1] - 1;
                                }
                                if (key < -6) {
                                    this.keysig[0] = this.keysig[0] - 1;
                                }
                            }
                        }
                        int acc = 0;
                        boolean acc_set = false;
                        while (ltoken.length() != 0) {
                            char cc = ltoken.charAt(0);
                            if (cc == '_') {
                                --acc;
                                acc_set = true;
                                ltoken = ltoken.substring(1);
                                continue;
                            }
                            if (cc == '^') {
                                ++acc;
                                acc_set = true;
                                ltoken = ltoken.substring(1);
                                continue;
                            }
                            if (cc != '=') break;
                            acc_set = true;
                            ltoken = ltoken.substring(1);
                        }
                        if (ltoken.length() != 1 || !acc_set || (li = this.notekeys.indexOf(ltoken.charAt(0))) == -1) continue;
                        this.keysig[li] = acc;
                    }
                } else {
                    fieldname.equals("Q");
                }
            }
            ++i;
        }
    }

    public static int gcd(int a, int b) {
        int shift = 0;
        while ((a & 1) == 0 && (b & 1) == 0) {
            a >>= 1;
            b >>= 1;
            ++shift;
        }
        while ((a & 1) == 0) {
            a >>= 1;
        }
        while (true) {
            if ((b & 1) == 0) {
                b >>= 1;
                continue;
            }
            int diff = a - b;
            if (diff < 0) {
                b = -diff;
            } else {
                a = b;
                b = diff;
            }
            b >>= 1;
            if (diff == 0) break;
        }
        return a << shift;
    }

    public static int[] rationalize(double val) {
        int[] ration;
        double delta;
        boolean neg;
        double input_val = val;
        int[] list = new int[100];
        int i = 0;
        double tol = 1.0E-10;
        boolean bl = neg = val < 0.0;
        if (neg) {
            val = -val;
        }
        do {
            double f = Math.floor(val);
            list[i] = (int)f;
            delta = val - f;
            val = 1.0 / delta;
            if (++i < list.length) continue;
            int[] ration2 = new int[]{(int)(input_val * 3.99168E7), 39916800};
            if (ration2[0] != 0) {
                int g = ABCTokenizer.gcd(ration2[0], ration2[1]);
                ration2[0] = ration2[0] / g;
                ration2[1] = ration2[1] / g;
            }
            return ration2;
        } while (Math.abs(delta) > tol);
        int a = list[--i];
        int b = 1;
        --i;
        while (i >= 0) {
            int baka = a;
            a = b + a * list[i];
            b = baka;
            --i;
        }
        if (neg) {
            a = -a;
        }
        if ((ration = new int[]{a, b})[0] != 0 && ration[1] != 1) {
            int g = ABCTokenizer.gcd(ration[0], ration[1]);
            ration[0] = ration[0] / g;
            ration[1] = ration[1] / g;
        }
        return ration;
    }

    public static double parseNoteLen(String notelen) {
        StringTokenizer st = new StringTokenizer(notelen, "/", true);
        double num = 1.0;
        boolean divmode = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("/")) {
                if (divmode) {
                    num /= 2.0;
                }
                divmode = true;
                continue;
            }
            num = divmode ? (num /= Double.parseDouble(token)) : (num *= Double.parseDouble(token));
            divmode = false;
        }
        return num;
    }

    public static String formatNoteLen(double notelen) {
        int[] rat = ABCTokenizer.rationalize(notelen);
        if (rat[1] == 1) {
            return Integer.toString(rat[0]);
        }
        if (rat[1] == 2) {
            return String.valueOf(Integer.toString(rat[0])) + "/";
        }
        if (rat[1] == 4) {
            return String.valueOf(Integer.toString(rat[0])) + "//";
        }
        return String.valueOf(rat[0]) + "/" + rat[1];
    }

    private void parseNotationLine(char[] code, int start, int end) {
        double barbeatpos = this.beatpos;
        double groupmaxlen = 0.0;
        int tuplet_count = 0;
        double tuplet_factor = 1.0;
        double next_brythmfactor = 1.0;
        int accidentals = 0;
        boolean accidentals_inuse = false;
        StringBuffer tokenbuffer = new StringBuffer();
        int i = start;
        while (i < end) {
            int starti;
            char c = code[i];
            if (c == '[' && i + 1 < end && code[i + 1] != '|') {
                starti = i + 1;
                while (i < end) {
                    if (code[i] == ']') break;
                    ++i;
                }
                boolean isCommand = false;
                int j = starti;
                while (j < i) {
                    if (code[j] == ':') {
                        isCommand = true;
                        break;
                    }
                    ++j;
                }
                tokenbuffer.setLength(0);
                if (isCommand) {
                    this.parseCommandLine(code, starti, i);
                } else {
                    this.isgrouping = true;
                    int from = starti;
                    int to = i;
                    starti = i;
                    while (i + 1 < end && (code[i + 1] == '/' || Character.isDigit(code[i + 1]))) {
                        ++i;
                    }
                    String notelen = "1";
                    if (starti != i) {
                        notelen = new String(code, starti + 1, i - starti);
                    }
                    this.groupmul = ABCTokenizer.parseNoteLen(notelen);
                    this.parseNotationLine(code, from, to);
                    this.groupmul = 1.0;
                    this.isgrouping = false;
                }
            } else if (c == '{') {
                ++i;
                while (i < end) {
                    if (code[i] == '}') break;
                    ++i;
                }
                ++i;
            } else if (c == '+') {
                ++i;
                while (i < end) {
                    if (code[i] == '+') break;
                    ++i;
                }
                ++i;
            } else if (c == '\"') {
                ++i;
                while (i < end) {
                    if (code[i] != '\"') {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (c == '=') {
                accidentals_inuse = true;
                tokenbuffer.append(c);
            } else if (c == '^') {
                ++accidentals;
                accidentals_inuse = true;
                tokenbuffer.append(c);
            } else if (c == '_') {
                --accidentals;
                accidentals_inuse = true;
                tokenbuffer.append(c);
            } else if (this.legalSymbols.indexOf(c) != -1) {
                int li;
                tokenbuffer.append(c);
                int octmodifier = 0;
                while (i + 1 < end && code[i + 1] == '\'') {
                    ++octmodifier;
                    tokenbuffer.append(code[i + 1]);
                    ++i;
                }
                while (i + 1 < end && code[i + 1] == ',') {
                    --octmodifier;
                    tokenbuffer.append(code[i + 1]);
                    ++i;
                }
                int starti2 = i;
                while (i + 1 < end && (code[i + 1] == '/' || Character.isDigit(code[i + 1]))) {
                    ++i;
                }
                String notelen = "1";
                if (starti2 != i) {
                    notelen = new String(code, starti2 + 1, i - starti2);
                }
                double d_notelen = ABCTokenizer.parseNoteLen(notelen) * this.notelen;
                if (tuplet_count != 0) {
                    d_notelen *= tuplet_factor;
                    --tuplet_count;
                }
                d_notelen *= next_brythmfactor;
                next_brythmfactor = 1.0;
                int dotted = 0;
                while (i + 1 < end && code[i + 1] == '>') {
                    ++i;
                    ++dotted;
                }
                if (dotted != 0) {
                    next_brythmfactor = 1.0 / (double)dotted;
                    d_notelen *= 1.0 + ((double)dotted - 1.0) / (double)dotted;
                }
                if (dotted == 0) {
                    while (i + 1 < end && code[i + 1] == '<') {
                        ++i;
                        ++dotted;
                    }
                    if (dotted != 0) {
                        d_notelen *= 1.0 / (double)dotted;
                        next_brythmfactor = 1.0 + ((double)dotted - 1.0) / (double)dotted;
                    }
                }
                if (this.isgrouping) {
                    d_notelen *= this.groupmul;
                }
                if (this.isgrouping && d_notelen > groupmaxlen) {
                    groupmaxlen = d_notelen;
                }
                if (!accidentals_inuse && (li = this.notekeys.indexOf(Character.toLowerCase(c))) != -1) {
                    accidentals = this.keysig[li];
                }
                ABCToken abctoken = new ABCToken();
                abctoken.symbol = c;
                abctoken.accidentals = accidentals;
                abctoken.octave = this.octave + octmodifier;
                abctoken.len = d_notelen * 4.0;
                abctoken.pos = this.beatpos * 4.0;
                abctoken.channel = this.channel;
                abctoken.velocity = this.velocity;
                abctoken.code = tokenbuffer.toString();
                this.tokens.add(abctoken);
                tokenbuffer.setLength(0);
                if (!this.isgrouping) {
                    this.beatpos += d_notelen;
                }
                accidentals = 0;
                accidentals_inuse = false;
            } else if (c == '|' || c == ':') {
                accidentals = 0;
                accidentals_inuse = false;
                next_brythmfactor = 1.0;
                barbeatpos = this.beatpos;
            } else if (c == '&') {
                this.beatpos = barbeatpos;
            } else if (c == '(' && i + 1 < end && (code[i + 1] == ':' || Character.isDigit(code[i + 1]))) {
                starti = i;
                while (i + 1 < end && (code[i + 1] == ':' || Character.isDigit(code[i + 1]))) {
                    ++i;
                }
                String tupletstr = new String(code, starti + 1, i - starti);
                StringTokenizer st = new StringTokenizer(tupletstr, ":", true);
                int fieldid = 0;
                String p = "";
                String q = "";
                String r = "";
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals(":")) {
                        ++fieldid;
                    }
                    if (fieldid == 0) {
                        p = token;
                    }
                    if (fieldid == 1) {
                        q = token;
                    }
                    if (fieldid != 2) continue;
                    r = token;
                }
                if (p.length() == 0) {
                    if (q.length() == 0) {
                        q = null;
                    }
                    if (r.length() == 0) {
                        r = null;
                    }
                    if (q == null || r == null) {
                        tuplet_count = Integer.parseInt(p);
                        double n = 2.0;
                        if (this.meter.startsWith("6/8")) {
                            n = 3.0;
                        } else if (this.meter.startsWith("9/8")) {
                            n = 3.0;
                        } else if (this.meter.startsWith("12/8")) {
                            n = 3.0;
                        }
                        switch (tuplet_count) {
                            case 2: {
                                tuplet_factor = 1.5;
                                break;
                            }
                            case 3: {
                                tuplet_factor = 0.6666666666666666;
                                break;
                            }
                            case 4: {
                                tuplet_factor = 0.75;
                                break;
                            }
                            case 5: {
                                tuplet_factor = n / 5.0;
                                break;
                            }
                            case 6: {
                                tuplet_factor = 0.3333333333333333;
                                break;
                            }
                            case 7: {
                                tuplet_factor = n / 7.0;
                                break;
                            }
                            case 8: {
                                tuplet_factor = 0.375;
                                break;
                            }
                            case 9: {
                                tuplet_factor = n / 9.0;
                                break;
                            }
                            default: {
                                tuplet_factor = 1.0;
                                break;
                            }
                        }
                    } else {
                        if (r == null) {
                            r = p;
                        }
                        if (q == null) {
                            q = r;
                        }
                        if (r != null && q != null) {
                            tuplet_count = Integer.parseInt(r);
                            tuplet_factor = (double)Integer.parseInt(q) / (double)Integer.parseInt(p);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.isgrouping) {
            this.beatpos += groupmaxlen;
        }
    }

    public static class ABCToken {
        public char symbol;
        public int accidentals = 0;
        public int octave = 0;
        public int channel = 1;
        public int velocity;
        public double len;
        public double pos;
        public String code;

        public String toString() {
            return this.code;
        }
    }

    public static class CommandToken {
        public int channel = 1;
        public String fieldname;
        public String fieldvalue;
        public String code;
        public double pos;

        public String toString() {
            return this.code;
        }
    }
}

