/*
 * Decompiled with CFR 0.152.
 */
package rasmus.testing;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class RasmusSynthesizerTesting2 {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        File soundbankfilename = null;
        File midifilename = null;
        Frame dummyframe = new Frame();
        FileDialog selectsoundbank = new FileDialog(dummyframe, "Select SoundFont", 0);
        selectsoundbank.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg0.getName().toLowerCase().endsWith(".sf2");
            }
        });
        selectsoundbank.setModal(true);
        selectsoundbank.setVisible(true);
        soundbankfilename = new File(new File(selectsoundbank.getDirectory()), selectsoundbank.getFile());
        if (soundbankfilename == null) {
            return;
        }
        selectsoundbank = new FileDialog(dummyframe, "Select MIDI File", 0);
        selectsoundbank.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg0.getName().toLowerCase().endsWith(".mid");
            }
        });
        selectsoundbank.setModal(true);
        selectsoundbank.setVisible(true);
        midifilename = new File(new File(selectsoundbank.getDirectory()), selectsoundbank.getFile());
        Soundbank soundbank = MidiSystem.getSoundbank(soundbankfilename);
        Instrument[] ins = soundbank.getInstruments();
        int i = 0;
        while (i < args.length) {
            System.out.println(ins[i].getName());
            ++i;
        }
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        MidiDevice.Info info = null;
        MidiDevice.Info rtinfo = null;
        int i2 = 0;
        while (i2 < infos.length) {
            if (infos[i2].getName().equals("RasmusDSP Synthesizer")) {
                info = infos[i2];
            }
            if (infos[i2].getName().equals("Real Time Sequencer")) {
                rtinfo = infos[i2];
            }
            ++i2;
        }
        if (info == null) {
            return;
        }
        if (rtinfo == null) {
            return;
        }
        System.out.println("Create Synthesizer...");
        Synthesizer mididevice = (Synthesizer)MidiSystem.getMidiDevice(info);
        System.out.println("Load Soundbank...");
        mididevice.loadAllInstruments(soundbank);
        System.out.println("Open Device...");
        mididevice.open();
        TargetDataLine dataline = (TargetDataLine)((Mixer)((Object)mididevice)).getLine(new Line.Info(TargetDataLine.class));
        AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
        dataline.open(format);
        Sequencer sequencer = (Sequencer)MidiSystem.getMidiDevice(rtinfo);
        sequencer.open();
        sequencer.getTransmitter().setReceiver(mididevice.getReceiver());
        Sequence sequence = MidiSystem.getSequence(midifilename);
        sequencer.setSequence(sequence);
        OutputWriterThread outputwriter = new OutputWriterThread();
        outputwriter.dataline = dataline;
        outputwriter.start();
        sequencer.start();
        System.out.println("Playing, press enter to stop");
        br.readLine();
        System.out.println("Stop...");
        sequencer.stop();
        outputwriter.active = false;
        outputwriter.join();
        dataline.close();
        mididevice.close();
        System.out.println("Finish...");
        System.exit(0);
    }

    static class OutputWriterThread
    extends Thread {
        boolean active = true;
        TargetDataLine dataline;

        OutputWriterThread() {
        }

        public void run() {
            try {
                FileOutputStream fos = new FileOutputStream("C:\\testaudio.raw");
                byte[] buffer = new byte[2000];
                double waittime = 0.011337868480725623;
                long sleepTime = (long)((waittime /= 2.0) * 1000.0 * 1000000.0);
                System.out.println("waittime = " + waittime);
                System.out.println("waittime = " + sleepTime / 1000000L);
                System.out.println("waittime = " + sleepTime % 1000000L);
                while (this.active) {
                    this.dataline.read(buffer, 0, buffer.length);
                    fos.write(buffer);
                    Thread.sleep(sleepTime / 1000000L, (int)(sleepTime % 1000000L));
                }
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

