/*
 * Decompiled with CFR 0.152.
 */
package rasmus.testing;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class RasmusSynthesizerTesting {
    public static void main(String[] args) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        File soundbankfilename = null;
        File midifilename = null;
        Frame dummyframe = new Frame();
        FileDialog selectsoundbank = new FileDialog(dummyframe, "Select SoundFont", 0);
        selectsoundbank.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg0.getName().toLowerCase().endsWith(".sf2");
            }
        });
        selectsoundbank.setModal(true);
        selectsoundbank.setVisible(true);
        soundbankfilename = new File(new File(selectsoundbank.getDirectory()), selectsoundbank.getFile());
        if (soundbankfilename == null) {
            return;
        }
        selectsoundbank = new FileDialog(dummyframe, "Select MIDI File", 0);
        selectsoundbank.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg0.getName().toLowerCase().endsWith(".mid");
            }
        });
        selectsoundbank.setModal(true);
        selectsoundbank.setVisible(true);
        midifilename = new File(new File(selectsoundbank.getDirectory()), selectsoundbank.getFile());
        Soundbank soundbank = MidiSystem.getSoundbank(soundbankfilename);
        Instrument[] ins = soundbank.getInstruments();
        int i = 0;
        while (i < args.length) {
            System.out.println(ins[i].getName());
            ++i;
        }
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        MidiDevice.Info info = null;
        MidiDevice.Info rtinfo = null;
        int i2 = 0;
        while (i2 < infos.length) {
            if (infos[i2].getName().equals("RasmusDSP Synthesizer")) {
                info = infos[i2];
            }
            if (infos[i2].getName().equals("Real Time Sequencer")) {
                rtinfo = infos[i2];
            }
            ++i2;
        }
        if (info == null) {
            return;
        }
        if (rtinfo == null) {
            return;
        }
        System.out.println("Create Synthesizer...");
        Synthesizer mididevice = (Synthesizer)MidiSystem.getMidiDevice(info);
        System.out.println("Load Soundbank...");
        mididevice.loadAllInstruments(soundbank);
        System.out.println("Open Device...");
        mididevice.open();
        Sequencer sequencer = (Sequencer)MidiSystem.getMidiDevice(rtinfo);
        sequencer.open();
        sequencer.getTransmitter().setReceiver(mididevice.getReceiver());
        Sequence sequence = MidiSystem.getSequence(midifilename);
        sequencer.setSequence(sequence);
        sequencer.start();
        System.out.println("Playing, press enter to stop");
        br.readLine();
        System.out.println("Stop...");
        sequencer.stop();
        mididevice.close();
        System.out.println("Finish...");
        System.exit(0);
    }
}

