/*
 * Decompiled with CFR 0.152.
 */
package rasmus.midi.provider;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.sound.midi.spi.SoundbankReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import rasmus.editor.RasmusEditor;
import rasmus.editor.RasmusSession;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.midi.InstrumentRecord;
import rasmus.interpreter.sampled.midi.VoiceRecord;
import rasmus.interpreter.sf2.SF2SoundFont;
import rasmus.interpreter.sf2.SF2SoundFontManager;
import rasmus.midi.provider.RasmusSoundbank;
import rasmus.midi.provider.RasmusSynthesizerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasmusSynthesizer
extends SoundbankReader
implements Synthesizer,
Mixer,
Externalizable,
Cloneable {
    private static final long serialVersionUID = 7554146056523862933L;
    RasmusEditor editor;
    RasmusSession session;
    Receiver recv;
    private static Icon icon = new ImageIcon(RasmusSynthesizer.class.getResource("/rasmus/rasmusdsp.PNG"));
    boolean isOpen = false;
    boolean isplaying = false;
    String name = "Rasmus Synthesizer";
    private boolean saveReferencedData = false;
    static Mixer.Info mixerinfo = new Mixer.Info("RasmusDSP Synthesizer", "RasmusDSP", "RasmusDSP Synthesizer", ""){};
    static Line.Info targetLineInfo = new Line.Info(TargetDataLine.class);
    Vector activeTargetLines = new Vector();
    Variable realtimeout = null;
    static Line.Info mixerLineInfo = new Line.Info(Mixer.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Icon getIcon() {
        return icon;
    }

    public RasmusSynthesizer clone() {
        this.editor.commit();
        RasmusSynthesizer synth = new RasmusSynthesizer();
        synth.saveReferencedData = this.saveReferencedData;
        synth.name = this.name;
        synth.session = new RasmusSession();
        ResourceManager.getInstance(synth.session.getNameSpace()).importResources(ResourceManager.getInstance(this.session.getNameSpace()));
        synth.session.getScriptDocument().setString(this.session.getScriptDocument().toString());
        synth.editor = new RasmusEditor(synth.session);
        synth.editor.setSynthName(this.name);
        synth.recv = MidiSequence.getInstance(synth.editor.getRealTimeInput());
        synth.editor.commit();
        return synth;
    }

    @Override
    public int getMaxPolyphony() {
        return -1;
    }

    @Override
    public long getLatency() {
        return -1L;
    }

    @Override
    public MidiChannel[] getChannels() {
        return null;
    }

    @Override
    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    @Override
    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    @Override
    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    @Override
    public void unloadInstrument(Instrument instrument) {
    }

    @Override
    public boolean remapInstrument(Instrument from, Instrument to) {
        return false;
    }

    @Override
    public Soundbank getDefaultSoundbank() {
        return null;
    }

    @Override
    public Instrument[] getAvailableInstruments() {
        return new Instrument[0];
    }

    @Override
    public Instrument[] getLoadedInstruments() {
        Variable instruments_var = this.session.getNameSpace().get("instruments");
        List list = ObjectsPart.asList(instruments_var);
        ArrayList<InstrumentRecord> ins_list = new ArrayList<InstrumentRecord>();
        for (Object object : list) {
            if (!(object instanceof InstrumentRecord)) continue;
            ins_list.add((InstrumentRecord)object);
        }
        InstrumentRecord[] inslist = new InstrumentRecord[ins_list.size()];
        ins_list.toArray(inslist);
        Arrays.sort(inslist, new InstrumentComparator());
        Instrument[] instruments = new Instrument[inslist.length];
        int i = 0;
        while (i < inslist.length) {
            InstrumentRecord element = inslist[i];
            Patch patch = new Patch(element.bank, element.program);
            LoadedInstrument instrument = new LoadedInstrument(element, null, patch, element.description, null);
            instruments[i] = instrument;
            ++i;
        }
        return instruments;
    }

    @Override
    public boolean loadAllInstruments(Soundbank soundbank) {
        if (!(soundbank instanceof RasmusSoundbank)) {
            return false;
        }
        String filename = ((RasmusSoundbank)soundbank).getFileName();
        String code = "\ninstruments <- soundbank(\"" + filename + "\"" + ");";
        this.editor.commit();
        this.session.getScriptDocument().getObject("instruments").setNormalizedString(code);
        this.editor.commit();
        this.editor.update();
        return true;
    }

    @Override
    public void unloadAllInstruments(Soundbank soundbank) {
        this.editor.commit();
        this.session.getScriptDocument().getObject("instruments").remove();
        this.editor.commit();
        this.editor.update();
    }

    @Override
    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        return false;
    }

    @Override
    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return RasmusSynthesizerProvider.infos[0];
    }

    public void show() {
        this.editor.setVisible(true);
        this.editor.toFront();
    }

    @Override
    public void open() {
        if (this.session == null) {
            this.session = new RasmusSession();
            this.editor = new RasmusEditor(this.session);
            this.editor.setSynthName(this.name);
            this.recv = MidiSequence.getInstance(this.editor.getRealTimeInput());
            if (this.realtimeout != null) {
                this.session.routeAudioOutput(this.realtimeout);
            }
        }
        this.isOpen = true;
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.editor.playStop();
        this.editor.setVisible(false);
        this.editor.dispose();
        this.session.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public int getMaxReceivers() {
        return 1;
    }

    @Override
    public int getMaxTransmitters() {
        return 0;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        if (!this.isplaying) {
            if (!this.isOpen) {
                return null;
            }
            this.editor.playRealTime();
            this.isplaying = true;
        }
        return this.recv;
    }

    @Override
    public List<Receiver> getReceivers() {
        ArrayList<Receiver> list = new ArrayList<Receiver>();
        try {
            list.add(this.getReceiver());
        }
        catch (MidiUnavailableException midiUnavailableException) {
            // empty catch block
        }
        return list;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException();
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return new ArrayList<Transmitter>();
    }

    public void setName(String name) {
        this.name = name;
        if (this.editor != null) {
            this.editor.setSynthName(name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getScript() {
        return this.session.getScriptDocument().toString();
    }

    public void setScript(String script) {
        this.editor.commit();
        this.session.getScriptDocument().setString(script);
        this.editor.update();
        this.editor.commit();
    }

    public void setSaveReferencedData(boolean saveReferencedData) {
        this.saveReferencedData = saveReferencedData;
    }

    public boolean getSaveReferencedData() {
        return this.saveReferencedData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.editor.commit();
        out.writeInt(2);
        out.writeObject(this.name);
        out.writeObject(this.session.getScriptDocument().toString());
        ResourceManager manager = ResourceManager.getInstance(this.session.getNameSpace());
        Collection<Resource> resources = manager.getResources();
        int count = resources.size();
        if (!this.saveReferencedData) {
            count = 0;
        }
        out.writeInt(count);
        if (count != 0) {
            for (Resource resource : resources) {
                String path = resource.getPath();
                out.writeObject(path);
                File file = resource.getFile();
                out.writeLong(file.length());
                FileInputStream fis = new FileInputStream(file);
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = fis.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                }
                finally {
                    fis.close();
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.session = new RasmusSession();
        int version = in.readInt();
        if (version > 2) {
            throw new IOException("Uncompatible version " + version);
        }
        this.name = (String)in.readObject();
        String code = (String)in.readObject();
        if (version > 1) {
            ResourceManager manager = ResourceManager.getInstance(this.session.getNameSpace());
            int count = in.readInt();
            int i = 0;
            while (i < count) {
                String path;
                String suffix = path = (String)in.readObject();
                long size = in.readLong();
                int li = suffix.lastIndexOf("/");
                if (li == -1) {
                    li = suffix.lastIndexOf("\\");
                }
                if (li != -1) {
                    suffix = suffix.substring(li + 1);
                }
                suffix = (li = path.lastIndexOf(".")) != -1 ? path.substring(li) : "";
                File tempfile = File.createTempFile("rasmusdsp", suffix);
                tempfile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tempfile);
                try {
                    byte[] buffer = new byte[1024];
                    while (size > 0L) {
                        if (size > 1024L) {
                            int ret = in.read(buffer, 0, 1024);
                            fos.write(buffer, 0, ret);
                            size -= (long)ret;
                            continue;
                        }
                        in.read(buffer, 0, (int)size);
                        fos.write(buffer, 0, (int)size);
                        size = 0L;
                    }
                }
                finally {
                    fos.close();
                }
                manager.importResource(path, tempfile);
                ++i;
            }
        }
        this.session.getScriptDocument().setString(code);
        this.editor = new RasmusEditor(this.session);
        this.editor.setSynthName(this.name);
        this.recv = MidiSequence.getInstance(this.editor.getRealTimeInput());
        if (this.realtimeout != null) {
            this.session.routeAudioOutput(this.realtimeout);
        }
    }

    @Override
    public Mixer.Info getMixerInfo() {
        return mixerinfo;
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        Line.Info[] infos = new Line.Info[]{targetLineInfo};
        return infos;
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info line) {
        if (this.isLineSupported(line)) {
            return this.getTargetLineInfo();
        }
        return new Line.Info[0];
    }

    @Override
    public boolean isLineSupported(Line.Info line) {
        return line.getLineClass() == TargetDataLine.class;
    }

    @Override
    public Line getLine(Line.Info lineinfo) throws LineUnavailableException {
        if (!this.isLineSupported(lineinfo)) {
            throw new IllegalArgumentException();
        }
        this.realtimeout = new Variable();
        try {
            Interpreter interpreter = new Interpreter();
            this.realtimeout.add(interpreter.eval("signal(0)"));
        }
        catch (ScriptParserException e1) {
            e1.printStackTrace();
        }
        TargetDataLine tdataline = new TargetDataLine(){
            AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
            AudioSession audiosession;
            InputStream audiostream;
            boolean isOpen = false;

            public void open(AudioFormat format, int arg1) throws LineUnavailableException {
                this.format = format;
                this.open();
            }

            public void open(AudioFormat format) throws LineUnavailableException {
                this.format = format;
                this.open();
            }

            public void open() throws LineUnavailableException {
                if (this.isOpen) {
                    return;
                }
                RasmusSynthesizer.this.activeTargetLines.add(this);
                this.isOpen = true;
                this.audiosession = new AudioSession(this.format.getSampleRate(), this.format.getChannels());
                this.audiosession.setRealTime(true);
                this.audiostream = this.audiosession.asByteStream(RasmusSynthesizer.this.realtimeout, this.format);
            }

            public void close() {
                if (!this.isOpen) {
                    return;
                }
                try {
                    this.audiostream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RasmusSynthesizer.this.activeTargetLines.remove(this);
                this.isOpen = false;
            }

            public boolean isOpen() {
                return this.isOpen;
            }

            public int read(byte[] arg0, int arg1, int arg2) {
                try {
                    this.audiosession.commit();
                    return this.audiostream.read(arg0, arg1, arg2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
            }

            public AudioFormat getFormat() {
                return this.format;
            }

            public void drain() {
            }

            public void flush() {
            }

            public void start() {
            }

            public void stop() {
            }

            public boolean isRunning() {
                return this.isOpen;
            }

            public boolean isActive() {
                return this.isOpen;
            }

            public int getBufferSize() {
                return -1;
            }

            public int available() {
                return -1;
            }

            public int getFramePosition() {
                return -1;
            }

            public long getLongFramePosition() {
                return -1L;
            }

            public long getMicrosecondPosition() {
                return -1L;
            }

            public float getLevel() {
                return 1.0f;
            }

            public Line.Info getLineInfo() {
                return targetLineInfo;
            }

            public Control[] getControls() {
                return new Control[0];
            }

            public boolean isControlSupported(Control.Type arg0) {
                return false;
            }

            public Control getControl(Control.Type arg0) {
                throw new IllegalArgumentException();
            }

            public void addLineListener(LineListener arg0) {
            }

            public void removeLineListener(LineListener arg0) {
            }
        };
        if (this.isOpen) {
            this.editor.playStop();
        }
        if (this.session != null) {
            this.session.routeAudioOutput(this.realtimeout);
        }
        if (this.isOpen) {
            this.editor.playRealTime();
            this.isplaying = true;
        }
        return tdataline;
    }

    @Override
    public Line[] getTargetLines() {
        Line[] lines = new Line[this.activeTargetLines.size()];
        this.activeTargetLines.toArray(lines);
        return lines;
    }

    @Override
    public Line.Info getLineInfo() {
        return mixerLineInfo;
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        return new Line.Info[0];
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info arg0) {
        return new Line.Info[0];
    }

    @Override
    public int getMaxLines(Line.Info arg0) {
        return -1;
    }

    @Override
    public Line[] getSourceLines() {
        return new Line[0];
    }

    @Override
    public void synchronize(Line[] arg0, boolean arg1) {
        throw new IllegalArgumentException();
    }

    @Override
    public void unsynchronize(Line[] arg0) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isSynchronizationSupported(Line[] arg0, boolean arg1) {
        return false;
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public boolean isControlSupported(Control.Type arg0) {
        return false;
    }

    @Override
    public Control getControl(Control.Type arg0) {
        throw new IllegalArgumentException();
    }

    @Override
    public void addLineListener(LineListener arg0) {
    }

    @Override
    public void removeLineListener(LineListener arg0) {
    }

    @Override
    public Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        return null;
    }

    @Override
    public Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        return null;
    }

    @Override
    public Soundbank getSoundbank(File arg0) throws InvalidMidiDataException, IOException {
        if (!arg0.exists()) {
            throw new InvalidMidiDataException();
        }
        SF2SoundFont sf2soundfont = SF2SoundFontManager.getSF2SoundFont(arg0.getPath());
        return new RasmusSoundbank(arg0.getPath(), sf2soundfont);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LoadedInstrument
    extends Instrument {
        InstrumentRecord element;
        String[] keys;

        protected LoadedInstrument(InstrumentRecord element, Soundbank soundbank, Patch patch, String name, Class<?> dataClass) {
            super(soundbank, patch, name, dataClass);
            this.keys = null;
            this.element = element;
        }

        public String[] getKeys() {
            if (this.keys != null) {
                return this.keys;
            }
            this.keys = new String[127];
            for (VoiceRecord voice : this.element.getVoices()) {
                int k = voice.getKeyFrom();
                while (k <= voice.getKeyTo()) {
                    if (this.keys[k] == null) {
                        String name = voice.getName();
                        if (name == null) {
                            name = this.element.getDescription();
                        }
                        if (name == null) {
                            name = "untitled";
                        }
                        this.keys[k] = name;
                    }
                    ++k;
                }
            }
            return this.keys;
        }

        public boolean[] getChannels() {
            return this.element.channels;
        }

        @Override
        public Object getData() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InstrumentComparator
    implements Comparator<InstrumentRecord> {
        InstrumentComparator() {
        }

        @Override
        public int compare(InstrumentRecord arg0, InstrumentRecord arg1) {
            int a = arg0.bank * 128 + arg0.program;
            int b = arg1.bank * 128 + arg1.program;
            return a - b;
        }
    }
}

