/*
 * Decompiled with CFR 0.152.
 */
package rasmus.midi.provider;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rasmus.interpreter.sf2.SF2SoundFont;
import rasmus.midi.provider.RasmusInstrument;

public class RasmusSoundbank
implements Soundbank {
    SF2SoundFont sf2soundfont;
    String filename;
    Element root;
    Instrument[] instruments;
    Map<Patch, Instrument> instrumentsmap = new TreeMap<Patch, Instrument>(new Comparator<Patch>(){

        @Override
        public int compare(Patch p1, Patch p2) {
            int i1 = p1.getBank() * 256 + p1.getProgram();
            int i2 = p2.getBank() * 256 + p2.getProgram();
            return i1 - i2;
        }
    });

    public RasmusSoundbank(String filename, SF2SoundFont sf2soundfont) {
        this.filename = filename;
        this.sf2soundfont = sf2soundfont;
        this.root = sf2soundfont.getDocument().getDocumentElement();
        NodeList presetlist = this.root.getElementsByTagName("preset");
        this.instruments = new Instrument[presetlist.getLength()];
        int i = 0;
        while (i < presetlist.getLength()) {
            Element preset = (Element)presetlist.item(i);
            Patch patch = new Patch(Integer.parseInt(preset.getAttribute("bank")), Integer.parseInt(preset.getAttribute("preset")));
            RasmusInstrument ins = new RasmusInstrument(this, patch, preset.getAttribute("name"));
            this.instruments[i] = ins;
            this.instrumentsmap.put(patch, ins);
            ++i;
        }
        Arrays.sort(this.instruments, new Comparator<Instrument>(){

            @Override
            public int compare(Instrument o1, Instrument o2) {
                Patch p1 = o1.getPatch();
                Patch p2 = o2.getPatch();
                int i1 = p1.getBank() * 256 + p1.getProgram();
                int i2 = p2.getBank() * 256 + p2.getProgram();
                return i1 - i2;
            }
        });
    }

    public String getFileName() {
        return this.filename;
    }

    public String getName() {
        return this.root.getAttribute("bankname");
    }

    public String getVersion() {
        return this.root.getAttribute("version");
    }

    public String getVendor() {
        return this.root.getAttribute("engineers");
    }

    public String getDescription() {
        return this.root.getAttribute("comments");
    }

    public SoundbankResource[] getResources() {
        return new SoundbankResource[0];
    }

    public Instrument[] getInstruments() {
        return this.instruments;
    }

    public Instrument getInstrument(Patch arg0) {
        return this.instrumentsmap.get(arg0);
    }
}

