/*
 * Decompiled with CFR 0.152.
 */
package rasmus.midi.provider;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import rasmus.midi.provider.MultiMidiCastDevice;

class MultiMidiCastReceiver
implements Receiver {
    MultiMidiCastDevice dev;
    int port;
    boolean isOpen = true;
    MulticastSocket ms = null;
    InetAddress ia;

    public MultiMidiCastReceiver(MultiMidiCastDevice dev) {
        this.dev = dev;
        this.port = dev.info.port;
        dev.receivers.add(this);
        try {
            this.ia = dev.multicasthost;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(MidiMessage arg0, long arg1) {
        if (this.ms == null) {
            try {
                this.ms = new MulticastSocket();
                this.ms.setTimeToLive(57);
                this.ms.setInterface(this.dev.localhost);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] data = arg0.getMessage();
        DatagramPacket dp = new DatagramPacket(data, data.length, this.ia, this.port + 21928);
        try {
            this.ms.send(dp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.dev.receivers.remove(this);
        try {
            if (this.ms != null) {
                this.ms.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ms = null;
    }
}

