/*
 * Decompiled with CFR 0.152.
 */
package rasmus.midi.provider;

import java.net.InetAddress;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import rasmus.midi.provider.MultiMidiCastInfo;
import rasmus.midi.provider.MultiMidiCastReceiver;
import rasmus.midi.provider.MultiMidiCastTransmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMidiCastDevice
implements MidiDevice {
    InetAddress localhost;
    InetAddress multicasthost;
    Vector<Receiver> receivers = new Vector();
    Vector<Transmitter> transmitters = new Vector();
    MultiMidiCastInfo info;
    boolean vIsOpen = false;
    private static Icon icon = new ImageIcon(MultiMidiCastDevice.class.getResource("/rasmus/midi/provider/ip_network.png"));
    static /* synthetic */ Class class$0;

    public Icon getIcon() {
        return icon;
    }

    public MultiMidiCastDevice(MultiMidiCastInfo info) {
        this.info = info;
        try {
            this.localhost = InetAddress.getLocalHost();
            this.multicasthost = InetAddress.getByName("225.0.0.37");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (!this.vIsOpen) {
            return;
        }
        this.vIsOpen = false;
        Object[] recvs = this.receivers.toArray();
        int i = 0;
        while (i < recvs.length) {
            ((Receiver)recvs[i]).close();
            ++i;
        }
        Object[] trans = this.transmitters.toArray();
        int i2 = 0;
        while (i2 < trans.length) {
            ((Transmitter)trans[i2]).close();
            ++i2;
        }
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    @Override
    public int getMaxReceivers() {
        return -1;
    }

    @Override
    public int getMaxTransmitters() {
        return -1;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return new MultiMidiCastReceiver(this);
    }

    @Override
    public List<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return new MultiMidiCastTransmitter(this);
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.transmitters;
    }

    @Override
    public boolean isOpen() {
        return this.vIsOpen;
    }

    @Override
    public void open() throws MidiUnavailableException {
        if (this.vIsOpen) {
            return;
        }
        this.vIsOpen = true;
    }
}

