/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.unit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.NameSpaceAdapter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;

public final class Parameters
extends NameSpaceAdapter {
    private Map<String, Object> map = new HashMap<String, Object>();
    private String[] names = null;
    private Variable[] values = null;

    public void setParameter(String name, Variable value) {
        this.getParameters().put(name.toLowerCase(), value);
        if (this.names != null) {
            this.names = null;
            this.values = null;
        }
    }

    public void setParameter(int paramno, Variable value) {
        this.map.put(Integer.toString(paramno), value);
    }

    public void setParameter(String name, double value) {
        this.getParameters().put(name.toLowerCase(), new Double(value));
        if (this.names != null) {
            this.names = null;
            this.values = null;
        }
    }

    public void setParameter(int paramno, double value) {
        this.map.put(Integer.toString(paramno), new Double(value));
    }

    public Parameters clone() {
        Parameters imap = new Parameters(this.getNameSpace());
        imap.map.putAll(this.map);
        return imap;
    }

    public Map getParameters() {
        if (this.map == null) {
            this.map = new HashMap<String, Object>();
            if (this.names != null) {
                int i = 0;
                while (i < this.names.length) {
                    this.map.put(this.names[i], this.values[i]);
                    ++i;
                }
            }
        }
        return this.map;
    }

    public void compact() {
        this.getNameSpace().addToCommitStack(new Commitable(){

            public int getRunLevel() {
                return 100;
            }

            public void commit() {
                if (Parameters.this.map == null) {
                    return;
                }
                if (Parameters.this.names != null) {
                    Parameters.this.map = null;
                    return;
                }
                int len = Parameters.this.map.entrySet().size();
                Parameters.this.names = new String[len];
                Parameters.this.values = new Variable[len];
                Iterator iterator = Parameters.this.map.entrySet().iterator();
                int i = 0;
                while (i < Parameters.this.names.length) {
                    if (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ((Parameters)Parameters.this).names[i] = (String)entry.getKey();
                        ((Parameters)Parameters.this).values[i] = (Variable)entry.getValue();
                    }
                    ++i;
                }
                Parameters.this.map = null;
            }
        });
    }

    public Parameters(NameSpace namspace) {
        this.setNameSpace(namspace);
    }

    public Variable getParameter(String name) {
        Object obj = this.getParameters().get(name.toLowerCase());
        if (obj instanceof Variable) {
            return (Variable)obj;
        }
        if (obj instanceof Double) {
            return DoublePart.asVariable((Double)obj);
        }
        return null;
    }

    public Variable getParameter(int paramno) {
        return this.getParameter(Integer.toString(paramno));
    }

    public Variable getParameter(int paramno, String name) {
        Variable ret = this.getParameter(name);
        if (ret != null) {
            return ret;
        }
        return this.getParameter(Integer.toString(paramno));
    }

    public Variable getParameterWithDefault(String name) {
        Variable ret = this.getParameter(name);
        if (ret != null) {
            return ret;
        }
        return new Variable();
    }

    public Variable getParameterWithDefault(int paramno) {
        Variable ret = this.getParameter(paramno);
        if (ret != null) {
            return ret;
        }
        return new Variable();
    }

    public Variable getParameterWithDefault(int paramno, String name) {
        Variable ret = this.getParameter(paramno, name);
        if (ret != null) {
            return ret;
        }
        return new Variable();
    }
}

