/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.struct;

import java.util.ArrayList;
import java.util.Iterator;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.struct.Struct;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class StructUnitInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable output;
    Variable answer = null;
    Variable input;
    ArrayList<Variable> vars = new ArrayList();
    NameSpace namespace;

    public StructUnitInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameter("input");
        int i = 1;
        Variable name = parameters.getParameter(i);
        Variable var = parameters.getParameter(++i);
        while (name != null) {
            this.vars.add(name);
            this.vars.add(var);
            if (name != null) {
                ObjectsPart.getInstance(name).addListener(this);
            }
            name = parameters.getParameter(++i);
            var = parameters.getParameter(++i);
        }
        this.calc();
    }

    public void close() {
        this.clear();
        Iterator<Variable> iter = this.vars.iterator();
        while (iter.hasNext()) {
            Variable name = iter.next();
            iter.next();
            if (name == null) continue;
            ObjectsPart.getInstance(name).removeListener(this);
        }
    }

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        this.clear();
        this.answer = new Variable();
        Struct struct = Struct.getInstance(this.answer);
        Iterator<Variable> iter = this.vars.iterator();
        while (iter.hasNext()) {
            Variable name = iter.next();
            Variable var = iter.next();
            if (var == null) {
                var = this.input;
            }
            if (var == null) continue;
            struct.get(ObjectsPart.toString(name)).add(var);
        }
        this.output.add(this.answer);
    }
}

